/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import android.view.View;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTVoidType;
import org.androidtransfuse.analysis.astAnalyzer.ASTInjectionAspect;
import org.androidtransfuse.config.Nullable;
import org.androidtransfuse.gen.ExpressionMatchingIterableFactory;
import org.androidtransfuse.gen.InjectionBuilderContext;
import org.androidtransfuse.gen.InjectionExpressionBuilder;
import org.androidtransfuse.gen.InvocationBuilder;
import org.androidtransfuse.gen.UniqueVariableNamer;
import org.androidtransfuse.gen.variableBuilder.ConsistentTypeVariableBuilder;
import org.androidtransfuse.gen.variableDecorator.TypedExpressionFactory;
import org.androidtransfuse.model.FieldInjectionPoint;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.MethodInjectionPoint;
import org.androidtransfuse.model.TypedExpression;
import org.androidtransfuse.model.r.RResource;
import org.androidtransfuse.model.r.RResourceReferenceBuilder;
import org.androidtransfuse.model.r.ResourceIdentifier;

public class FragmentViewVariableBuilder
extends ConsistentTypeVariableBuilder {
    private static final String FIND_VIEW_BY_ID = "findViewById";
    private static final String FIND_VIEW_BY_TAG = "findViewWithTag";
    private final JType viewType;
    private final Integer viewId;
    private final String viewTag;
    private final InjectionNode viewInjectionNode;
    private final InjectionExpressionBuilder injectionExpressionBuilder;
    private final RResourceReferenceBuilder rResourceReferenceBuilder;
    private final JCodeModel codeModel;
    private final UniqueVariableNamer variableNamer;
    private final InvocationBuilder injectionInvocationBuilder;
    private final RResource rResource;
    private final ExpressionMatchingIterableFactory generatorFactory;

    @Inject
    public FragmentViewVariableBuilder(@Nullable Integer viewId, @Nullable String viewTag, InjectionNode viewInjectionNode, JType viewType, InjectionExpressionBuilder injectionExpressionBuilder, RResourceReferenceBuilder rResourceReferenceBuilder, JCodeModel codeModel, InvocationBuilder injectionInvocationBuilder, UniqueVariableNamer variableNamer, RResource rResource, TypedExpressionFactory typedExpressionFactory, ExpressionMatchingIterableFactory generatorFactory) {
        super(View.class, typedExpressionFactory);
        this.viewId = viewId;
        this.viewTag = viewTag;
        this.viewInjectionNode = viewInjectionNode;
        this.viewType = viewType;
        this.injectionExpressionBuilder = injectionExpressionBuilder;
        this.rResourceReferenceBuilder = rResourceReferenceBuilder;
        this.codeModel = codeModel;
        this.injectionInvocationBuilder = injectionInvocationBuilder;
        this.variableNamer = variableNamer;
        this.rResource = rResource;
        this.generatorFactory = generatorFactory;
    }

    public JExpression buildExpression(InjectionBuilderContext injectionBuilderContext, InjectionNode injectionNode) {
        try {
            JInvocation viewExpression;
            this.injectionExpressionBuilder.setupInjectionRequirements(injectionBuilderContext, injectionNode);
            TypedExpression contextVar = this.injectionExpressionBuilder.buildVariable(injectionBuilderContext, this.viewInjectionNode);
            if (this.viewId != null) {
                ResourceIdentifier viewResourceIdentifier = this.rResource.getResourceIdentifier(this.viewId);
                JExpression viewIdRef = this.rResourceReferenceBuilder.buildReference(viewResourceIdentifier);
                viewExpression = contextVar.getExpression().invoke(FIND_VIEW_BY_ID).arg(viewIdRef);
            } else {
                viewExpression = contextVar.getExpression().invoke(FIND_VIEW_BY_TAG).arg(JExpr.lit((String)this.viewTag));
            }
            if (injectionNode.containsAspect(ASTInjectionAspect.class)) {
                return this.inject((ASTInjectionAspect)injectionNode.getAspect(ASTInjectionAspect.class), injectionBuilderContext, injectionNode, (JExpression)viewExpression);
            }
            return viewExpression;
        }
        catch (ClassNotFoundException e) {
            throw new TransfuseAnalysisException("Unable to parse class: " + injectionNode.getClassName(), (Throwable)e);
        }
        catch (JClassAlreadyExistsException e) {
            throw new TransfuseAnalysisException("JClassAlreadyExistsException while generating injection: " + injectionNode.getClassName(), (Throwable)e);
        }
    }

    public JVar inject(ASTInjectionAspect injectionAspect, InjectionBuilderContext injectionBuilderContext, InjectionNode injectionNode, JExpression viewExpression) throws ClassNotFoundException, JClassAlreadyExistsException {
        JType nodeType = this.codeModel.parseType(injectionNode.getClassName());
        Object variableRef = injectionAspect.getAssignmentType().equals((Object)ASTInjectionAspect.InjectionAssignmentType.LOCAL) ? injectionBuilderContext.getBlock().decl(nodeType, this.variableNamer.generateName(injectionNode)) : injectionBuilderContext.getDefinedClass().field(4, nodeType, this.variableNamer.generateName(injectionNode));
        JBlock block = injectionBuilderContext.getBlock();
        block.assign((JAssignmentTarget)variableRef, (JExpression)JExpr.cast((JType)this.viewType, (JExpression)viewExpression));
        for (ASTInjectionAspect.InjectionGroup injectionGroup : injectionAspect.getGroups()) {
            for (FieldInjectionPoint fieldInjectionPoint : injectionGroup.getFieldInjectionPoints()) {
                block.add(this.injectionInvocationBuilder.buildFieldSet((TypedExpression)injectionBuilderContext.getVariableMap().get(fieldInjectionPoint.getInjectionNode()), fieldInjectionPoint, (JExpression)variableRef));
            }
            for (MethodInjectionPoint methodInjectionPoint : injectionGroup.getMethodInjectionPoints()) {
                block.add((JStatement)this.injectionInvocationBuilder.buildMethodCall((ASTType)ASTVoidType.VOID, methodInjectionPoint, (Iterable)this.generatorFactory.buildExpressionMatchingIterable(injectionBuilderContext.getVariableMap(), methodInjectionPoint.getInjectionNodes()), (JExpression)variableRef));
            }
        }
        return variableRef;
    }
}

