/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import android.content.Context;
import android.preference.PreferenceManager;
import com.google.common.collect.ImmutableList;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.gen.variableBuilder.DependentVariableBuilder;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionBuilderFactory;
import org.androidtransfuse.model.TypedExpression;

public class InjectionBindingBuilder {
    private final VariableInjectionBuilderFactory variableInjectionBuilderFactory;
    private final ASTClassFactory astClassFactory;

    @Inject
    public InjectionBindingBuilder(VariableInjectionBuilderFactory variableInjectionBuilderFactory, ASTClassFactory astClassFactory) {
        this.variableInjectionBuilderFactory = variableInjectionBuilderFactory;
        this.astClassFactory = astClassFactory;
    }

    public DependencyBindingBuilder dependency(Class clazz) {
        return new DependencyBindingBuilder(clazz);
    }

    public StaticInvocationBindingBuilder staticInvoke(Class<PreferenceManager> invocationTarget, Class returnType, String method) {
        return new StaticInvocationBindingBuilder(invocationTarget, returnType, method);
    }

    public InjectionNodeBuilder buildThis(Class targetClass) {
        ASTType astType = this.astClassFactory.getType(targetClass);
        return this.buildThis(astType);
    }

    public InjectionNodeBuilder buildThis(ASTType targetType) {
        return this.variableInjectionBuilderFactory.buildInjectionNodeBuilder((VariableBuilder)this.variableInjectionBuilderFactory.buildIndependentVariableBuilderWrapper(targetType, JExpr._this()));
    }

    public InjectionNodeBuilder buildExpression(TypedExpression typedExpression) {
        return this.variableInjectionBuilderFactory.buildInjectionNodeBuilder((VariableBuilder)this.variableInjectionBuilderFactory.buildExpressionWrapper(typedExpression));
    }

    public final class DependencyBindingBuilder {
        private final Class clazz;

        private DependencyBindingBuilder(Class clazz) {
            this.clazz = clazz;
        }

        public DependantVariableBuilderWrapper invoke(Class returnType, DependentVariableBuilder dependentVariableBuilder) {
            return new DependantVariableBuilderWrapper(returnType, dependentVariableBuilder);
        }

        public DependencyArgumentBindingBuilder invoke(Class returnType, String methodName) {
            return new DependencyArgumentBindingBuilder(this.clazz, returnType, methodName);
        }

        public final class DependantVariableBuilderWrapper {
            private final DependentVariableBuilder dependentVariableBuilder;
            private final Class returnType;

            private DependantVariableBuilderWrapper(Class returnType, DependentVariableBuilder dependentVariableBuilder) {
                this.returnType = returnType;
                this.dependentVariableBuilder = dependentVariableBuilder;
            }

            public InjectionNodeBuilder build() {
                return InjectionBindingBuilder.this.variableInjectionBuilderFactory.buildDependentInjectionNodeBuilder(DependencyBindingBuilder.this.clazz, this.returnType, this.dependentVariableBuilder);
            }
        }

        public final class DependencyArgumentBindingBuilder {
            private final Class clazz;
            private final Class returnType;
            private final String methodName;
            private final ImmutableList.Builder<JExpression> arguments = ImmutableList.builder();

            private DependencyArgumentBindingBuilder(Class clazz, Class returnType, String methodName) {
                this.clazz = clazz;
                this.returnType = returnType;
                this.methodName = methodName;
            }

            public DependencyArgumentBindingBuilder arg(JExpression value) {
                this.arguments.add((Object)value);
                return this;
            }

            public InjectionNodeBuilder build() {
                return InjectionBindingBuilder.this.variableInjectionBuilderFactory.buildDependentInjectionNodeBuilder(this.clazz, this.returnType, InjectionBindingBuilder.this.variableInjectionBuilderFactory.buildMethodCallVariableBuilder(this.methodName, (ImmutableList<JExpression>)this.arguments.build()));
            }
        }
    }

    public final class StaticInvocationBindingBuilderArgument {
        private final StaticInvocationBindingBuilder parent;
        private final Class dependency;

        private StaticInvocationBindingBuilderArgument(StaticInvocationBindingBuilder parent, Class dependency) {
            this.parent = parent;
            this.dependency = dependency;
        }

        public InjectionNodeBuilder build() {
            return InjectionBindingBuilder.this.variableInjectionBuilderFactory.buildDependentInjectionNodeBuilder(this.dependency, this.parent.returnType, InjectionBindingBuilder.this.variableInjectionBuilderFactory.buildStaticInvocationVariableBuilder(this.parent.invocationTarget, this.parent.method));
        }
    }

    public final class StaticInvocationBindingBuilder {
        private final Class invocationTarget;
        private final Class returnType;
        private final String method;

        private StaticInvocationBindingBuilder(Class invocationTarget, Class returnType, String method) {
            this.invocationTarget = invocationTarget;
            this.returnType = returnType;
            this.method = method;
        }

        public StaticInvocationBindingBuilderArgument dependencyArg(Class<Context> dependency) {
            return new StaticInvocationBindingBuilderArgument(this, dependency);
        }
    }
}

