/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import com.google.common.collect.ImmutableList;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import javax.inject.Inject;
import org.androidtransfuse.gen.variableBuilder.DependentVariableBuilder;

public class MethodCallVariableBuilder
implements DependentVariableBuilder {
    private final String methodName;
    private final ImmutableList<JExpression> arguments;

    @Inject
    public MethodCallVariableBuilder(String methodName, ImmutableList<JExpression> arguments) {
        this.methodName = methodName;
        this.arguments = arguments;
    }

    @Override
    public JExpression buildVariable(JExpression dependencyExpression) {
        JInvocation invocation = dependencyExpression.invoke(this.methodName);
        for (JExpression argument : this.arguments) {
            invocation.arg(argument);
        }
        return invocation;
    }
}

