/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import android.content.SharedPreferences;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.Analyzer;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.annotations.Preference;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilderSingleAnnotationAdapter;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionBuilderFactory;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.InjectionSignature;

public class PreferenceInjectionNodeBuilder
extends InjectionNodeBuilderSingleAnnotationAdapter {
    private final VariableInjectionBuilderFactory variableInjectionBuilderFactory;
    private final InjectionPointFactory injectionPointFactory;
    private final Analyzer analyzer;

    @Inject
    public PreferenceInjectionNodeBuilder(VariableInjectionBuilderFactory variableInjectionBuilderFactory, InjectionPointFactory injectionPointFactory, Analyzer analyzer) {
        super(Preference.class);
        this.variableInjectionBuilderFactory = variableInjectionBuilderFactory;
        this.injectionPointFactory = injectionPointFactory;
        this.analyzer = analyzer;
    }

    public InjectionNode buildInjectionNode(InjectionSignature signature, AnalysisContext context, ASTAnnotation annotation) {
        String preferenceName = (String)annotation.getProperty("value", String.class);
        InjectionNode injectionNode = this.analyzer.analyze(signature, context);
        InjectionNode preferenceManagerInjectionNode = this.injectionPointFactory.buildInjectionNode(SharedPreferences.class, context);
        injectionNode.addAspect(VariableBuilder.class, (Object)this.variableInjectionBuilderFactory.buildPreferenceVariableBuilder(signature.getType(), preferenceName, preferenceManagerInjectionNode));
        return injectionNode;
    }
}

