/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;
import org.androidtransfuse.gen.InjectionBuilderContext;
import org.androidtransfuse.gen.InjectionExpressionBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.gen.variableDecorator.TypedExpressionFactory;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.TypedExpression;

public class PreferenceVariableBuilder
implements VariableBuilder {
    private final ASTType preferenceType;
    private final String preferenceName;
    private final InjectionNode preferenceManagerInjectionNode;
    private final TypedExpressionFactory typedExpressionFactory;
    private final InjectionExpressionBuilder injectionExpressionBuilder;
    private Map<ASTType, PrefGetBuilder> accessorMethods = new HashMap<ASTType, PrefGetBuilder>();

    @Inject
    public PreferenceVariableBuilder(ASTType preferenceType, String preferenceName, InjectionNode preferenceManagerInjectionNode, TypedExpressionFactory typedExpressionFactory, InjectionExpressionBuilder injectionExpressionBuilder, ASTClassFactory astClassFactory) {
        this.preferenceName = preferenceName;
        this.preferenceManagerInjectionNode = preferenceManagerInjectionNode;
        this.typedExpressionFactory = typedExpressionFactory;
        this.injectionExpressionBuilder = injectionExpressionBuilder;
        this.preferenceType = preferenceType;
        this.accessorMethods.put(astClassFactory.getType(String.class), new PrefGetBuilder("getString", JExpr.lit((String)"")));
        this.accessorMethods.put(astClassFactory.getType(Long.TYPE), new PrefGetBuilder("getLong", JExpr.lit((long)0L)));
        this.accessorMethods.put(astClassFactory.getType(Integer.TYPE), new PrefGetBuilder("getInt", JExpr.lit((int)0)));
        this.accessorMethods.put(astClassFactory.getType(Float.TYPE), new PrefGetBuilder("getFloat", JExpr.lit((float)0.0f)));
        this.accessorMethods.put(astClassFactory.getType(Boolean.TYPE), new PrefGetBuilder("getBoolean", JExpr.lit((boolean)false)));
        this.accessorMethods.put(astClassFactory.getType(Long.class), new PrefGetBuilder("getLong", JExpr.lit((long)0L)));
        this.accessorMethods.put(astClassFactory.getType(Integer.class), new PrefGetBuilder("getInt", JExpr.lit((int)0)));
        this.accessorMethods.put(astClassFactory.getType(Float.class), new PrefGetBuilder("getFloat", JExpr.lit((float)0.0f)));
        this.accessorMethods.put(astClassFactory.getType(Boolean.class), new PrefGetBuilder("getBoolean", JExpr.lit((boolean)false)));
    }

    public TypedExpression buildVariable(InjectionBuilderContext injectionBuilderContext, InjectionNode injectionNode) {
        TypedExpression preferenceManagerExpression = this.injectionExpressionBuilder.buildVariable(injectionBuilderContext, this.preferenceManagerInjectionNode);
        JExpression expression = this.invokePreferenceMethod(preferenceManagerExpression.getExpression());
        return this.typedExpressionFactory.build(this.preferenceType, expression);
    }

    private JExpression invokePreferenceMethod(JExpression preferences) {
        if (this.accessorMethods.containsKey(this.preferenceType)) {
            PrefGetBuilder getBuilder = this.accessorMethods.get(this.preferenceType);
            return preferences.invoke(getBuilder.getName()).arg(this.preferenceName).arg(getBuilder.getLit());
        }
        throw new TransfuseAnalysisException("Unable to find preference accessor method for " + this.preferenceType);
    }

    private static final class PrefGetBuilder {
        private String name;
        private JExpression lit;

        private PrefGetBuilder(String name, JExpression lit) {
            this.name = name;
            this.lit = lit;
        }

        public JExpression getLit() {
            return this.lit;
        }

        public String getName() {
            return this.name;
        }
    }
}

