/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import javax.inject.Inject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.Analyzer;
import org.androidtransfuse.annotations.Resource;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilderSingleAnnotationAdapter;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionBuilderFactory;
import org.androidtransfuse.gen.variableBuilder.resource.ResourceExpressionBuilder;
import org.androidtransfuse.gen.variableBuilder.resource.ResourceExpressionBuilderFactory;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.InjectionSignature;

public class ResourceInjectionNodeBuilder
extends InjectionNodeBuilderSingleAnnotationAdapter {
    private final JCodeModel codeModel;
    private final VariableInjectionBuilderFactory variableInjectionBuilderFactory;
    private final ResourceExpressionBuilderFactory resourceExpressionBuilderFactory;
    private final Analyzer analyzer;

    @Inject
    public ResourceInjectionNodeBuilder(JCodeModel codeModel, VariableInjectionBuilderFactory variableInjectionBuilderFactory, ResourceExpressionBuilderFactory resourceExpressionBuilderFactory, Analyzer analyzer) {
        super(Resource.class);
        this.codeModel = codeModel;
        this.variableInjectionBuilderFactory = variableInjectionBuilderFactory;
        this.resourceExpressionBuilderFactory = resourceExpressionBuilderFactory;
        this.analyzer = analyzer;
    }

    public InjectionNode buildInjectionNode(InjectionSignature signature, AnalysisContext context, ASTAnnotation annotation) {
        Integer resourceId = (Integer)annotation.getProperty("value", Integer.class);
        InjectionNode injectionNode = this.analyzer.analyze(signature, context);
        try {
            JType resourceType = this.codeModel.parseType(signature.getType().getName());
            ResourceExpressionBuilder resourceExpressionBuilder = this.resourceExpressionBuilderFactory.buildResourceExpressionBuilder(resourceType, context);
            injectionNode.addAspect(VariableBuilder.class, (Object)this.variableInjectionBuilderFactory.buildResourceVariableBuilder(resourceId, resourceExpressionBuilder));
        }
        catch (ClassNotFoundException e) {
            throw new TransfuseAnalysisException("Unable to parse type " + signature.getType().getName(), (Throwable)e);
        }
        return injectionNode;
    }
}

