/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpression;
import javax.inject.Inject;
import org.androidtransfuse.gen.variableBuilder.DependentVariableBuilder;

public class StaticInvocationVariableBuilder
implements DependentVariableBuilder {
    private final Class invocationTarget;
    private final String staticInvocation;
    private final JCodeModel codeModel;

    @Inject
    public StaticInvocationVariableBuilder(Class invocationTarget, String staticInvocation, JCodeModel codeModel) {
        this.invocationTarget = invocationTarget;
        this.staticInvocation = staticInvocation;
        this.codeModel = codeModel;
    }

    @Override
    public JExpression buildVariable(JExpression dependencyExpression) {
        return this.codeModel.ref(this.invocationTarget).staticInvoke(this.staticInvocation).arg(dependencyExpression);
    }
}

