/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder;

import android.content.Context;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.analysis.Analyzer;
import org.androidtransfuse.analysis.InjectionPointFactory;
import org.androidtransfuse.annotations.SystemService;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilderSingleAnnotationAdapter;
import org.androidtransfuse.gen.variableBuilder.VariableBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionBuilderFactory;
import org.androidtransfuse.model.InjectionNode;
import org.androidtransfuse.model.InjectionSignature;

public class SystemServiceBindingInjectionNodeBuilder
extends InjectionNodeBuilderSingleAnnotationAdapter {
    private final InjectionPointFactory injectionPointFactory;
    private final VariableInjectionBuilderFactory variableInjectionBuilderFactory;
    private final Analyzer analyzer;

    @Inject
    public SystemServiceBindingInjectionNodeBuilder(InjectionPointFactory injectionPointFactory, VariableInjectionBuilderFactory variableInjectionBuilderFactory, Analyzer analyzer) {
        super(SystemService.class);
        this.injectionPointFactory = injectionPointFactory;
        this.variableInjectionBuilderFactory = variableInjectionBuilderFactory;
        this.analyzer = analyzer;
    }

    public InjectionNode buildInjectionNode(InjectionSignature signature, AnalysisContext context, ASTAnnotation annotation) {
        String systemService = (String)annotation.getProperty("value", String.class);
        InjectionNode injectionNode = this.analyzer.analyze(signature, context);
        InjectionNode contextInjectionNode = this.injectionPointFactory.buildInjectionNode(Context.class, context);
        injectionNode.addAspect(VariableBuilder.class, (Object)this.variableInjectionBuilderFactory.buildSystemServiceVariableBuilder(systemService, contextInjectionNode));
        return injectionNode;
    }
}

