/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.gen.variableBuilder.resource;

import android.content.res.ColorStateList;
import android.graphics.Movie;
import android.graphics.drawable.Drawable;
import android.view.animation.Animation;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.androidtransfuse.analysis.AnalysisContext;
import org.androidtransfuse.gen.variableBuilder.resource.MethodBasedResourceExpressionBuilderAdaptorFactory;
import org.androidtransfuse.gen.variableBuilder.resource.ResourceExpressionBuilder;
import org.androidtransfuse.gen.variableBuilder.resource.ResourceExpressionBuilderAdaptor;

public class ResourceExpressionBuilderFactory {
    private static final String GET_STRING = "getString";
    private static final String GET_BOOLEAN = "getBoolean";
    private static final String GET_COLORSTATELIST = "getColorStateList";
    private static final String GET_INTEGER = "getInteger";
    private static final String GET_DRAWABLE = "getDrawable";
    private static final String GET_STRINGARRAY = "getStringArray";
    private static final String GET_INTARRAY = "getIntArray";
    private static final String GET_MOVIE = "getMovie";
    private final JCodeModel codeModel;
    private final Map<JType, ResourceExpressionBuilderAdaptor> resourceExpressionBuilderMap = new HashMap<JType, ResourceExpressionBuilderAdaptor>();
    private final MethodBasedResourceExpressionBuilderAdaptorFactory adaptorFactory;

    @Inject
    public ResourceExpressionBuilderFactory(MethodBasedResourceExpressionBuilderAdaptorFactory adaptorFactory, JCodeModel codeModel) {
        this.codeModel = codeModel;
        this.adaptorFactory = adaptorFactory;
        this.addMethodBasedResourceBuider(String.class, GET_STRING);
        this.addMethodBasedResourceBuider(String.class, GET_STRING);
        this.addMethodBasedResourceBuider(Boolean.class, GET_BOOLEAN);
        this.addMethodBasedResourceBuider(Boolean.TYPE, GET_BOOLEAN);
        this.addMethodBasedResourceBuider(ColorStateList.class, GET_COLORSTATELIST);
        this.addMethodBasedResourceBuider(Integer.class, GET_INTEGER);
        this.addMethodBasedResourceBuider(Integer.TYPE, GET_INTEGER);
        this.addMethodBasedResourceBuider(Drawable.class, GET_DRAWABLE);
        this.addMethodBasedResourceBuider(String[].class, GET_STRINGARRAY);
        this.addMethodBasedResourceBuider(Integer[].class, GET_INTARRAY);
        this.addMethodBasedResourceBuider(int[].class, GET_INTARRAY);
        this.addMethodBasedResourceBuider(Movie.class, GET_MOVIE);
        this.addAnimationResourceBuilder(Animation.class);
    }

    private void addMethodBasedResourceBuider(Class clazz, String method) {
        JType refClass = this.codeModel._ref(clazz);
        this.resourceExpressionBuilderMap.put(refClass, this.adaptorFactory.buildMethodBasedResourceExpressionBuilderAdaptor(clazz, method));
    }

    private void addAnimationResourceBuilder(Class clazz) {
        JType refClass = this.codeModel._ref(clazz);
        this.resourceExpressionBuilderMap.put(refClass, this.adaptorFactory.buildAnimationResourceExpressionBuilderAdaptor());
    }

    public ResourceExpressionBuilder buildResourceExpressionBuilder(JType resourceType, AnalysisContext context) {
        ResourceExpressionBuilderAdaptor resourceExpressionBuilderAdaptor = this.resourceExpressionBuilderMap.get(resourceType);
        return resourceExpressionBuilderAdaptor.buildResourceExpressionBuilder(context);
    }
}

