/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.gen.componentBuilder.ExpressionVariableDependentGenerator;
import org.androidtransfuse.gen.componentBuilder.InjectionNodeFactory;
import org.androidtransfuse.gen.componentBuilder.MethodBuilder;

public class ComponentDescriptor {
    private final PackageClass packageClass;
    private final String type;
    private MethodBuilder initMethodBuilder;
    private List<ExpressionVariableDependentGenerator> generators = new ArrayList<ExpressionVariableDependentGenerator>();
    private List<ExpressionVariableDependentGenerator> registrations = new ArrayList<ExpressionVariableDependentGenerator>();
    private InjectionNodeFactory injectionNodeFactory;
    private ASTType initMethodEventAnnotation;

    public ComponentDescriptor(String type, PackageClass packageClass) {
        this.type = type;
        this.packageClass = packageClass;
    }

    public PackageClass getPackageClass() {
        return this.packageClass;
    }

    public String getType() {
        return this.type;
    }

    public MethodBuilder getInitMethodBuilder() {
        return this.initMethodBuilder;
    }

    public List<ExpressionVariableDependentGenerator> getGenerators() {
        return this.generators;
    }

    public void addGenerators(Collection<ExpressionVariableDependentGenerator> generators) {
        this.generators.addAll(generators);
    }

    public void addGenerators(ExpressionVariableDependentGenerator ... generators) {
        if (generators != null) {
            this.addGenerators(Arrays.asList(generators));
        }
    }

    public void setInitMethodBuilder(ASTType initEventAnnotation, MethodBuilder initMethodBuilder) {
        this.initMethodBuilder = initMethodBuilder;
        this.initMethodEventAnnotation = initEventAnnotation;
    }

    public InjectionNodeFactory getInjectionNodeFactory() {
        return this.injectionNodeFactory;
    }

    public void setInjectionNodeFactory(InjectionNodeFactory injectionNodeFactory) {
        this.injectionNodeFactory = injectionNodeFactory;
    }

    public ASTType getInitMethodEventAnnotation() {
        return this.initMethodEventAnnotation;
    }

    public List<ExpressionVariableDependentGenerator> getRegistrations() {
        return this.registrations;
    }

    public void addRegistration(ExpressionVariableDependentGenerator generator) {
        this.registrations.add(generator);
    }
}

