/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.model.manifest;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.androidtransfuse.annotations.UIOptions;
import org.androidtransfuse.model.Identified;
import org.androidtransfuse.model.Mergeable;
import org.androidtransfuse.model.manifest.Activity;
import org.androidtransfuse.model.manifest.ActivityAlias;
import org.androidtransfuse.model.manifest.Provider;
import org.androidtransfuse.model.manifest.Receiver;
import org.androidtransfuse.model.manifest.Service;
import org.androidtransfuse.model.manifest.UsesLibrary;
import org.androidtransfuse.processor.Merge;
import org.androidtransfuse.processor.MergeCollection;

@XStreamAlias(value="application")
public class Application
extends Mergeable
implements Identified {
    @XStreamAlias(value="android:allowTaskReparenting")
    @XStreamAsAttribute
    private Boolean allowTaskReparenting;
    @XStreamAlias(value="android:backupAgent")
    @XStreamAsAttribute
    private String backupAgent;
    @XStreamAlias(value="android:debuggable")
    @XStreamAsAttribute
    private Boolean debuggable;
    @XStreamAlias(value="android:description")
    @XStreamAsAttribute
    private String description;
    @XStreamAlias(value="android:enabled")
    @XStreamAsAttribute
    private Boolean enabled;
    @XStreamAlias(value="android:hasCode")
    @XStreamAsAttribute
    private Boolean hasCode;
    @XStreamAlias(value="android:hardwareAccelerated")
    @XStreamAsAttribute
    private Boolean hardwareAccelerated;
    @XStreamAlias(value="android:icon")
    @XStreamAsAttribute
    private String icon;
    @XStreamAlias(value="android:killAfterRestore")
    @XStreamAsAttribute
    private Boolean killAfterRestore;
    @XStreamAlias(value="android:label")
    @XStreamAsAttribute
    private String label;
    @XStreamAlias(value="android:logo")
    @XStreamAsAttribute
    private String logo;
    @XStreamAlias(value="android:manageSpaceActivity")
    @XStreamAsAttribute
    private String manageSpaceActivity;
    @XStreamAlias(value="android:name")
    @XStreamAsAttribute
    private String name;
    @XStreamAlias(value="android:permission")
    @XStreamAsAttribute
    private String permission;
    @XStreamAlias(value="android:persistent")
    @XStreamAsAttribute
    private Boolean persistent;
    @XStreamAlias(value="android:process")
    @XStreamAsAttribute
    private String process;
    @XStreamAlias(value="android:restoreAnyVersion")
    @XStreamAsAttribute
    private Boolean restoreAnyVersion;
    @XStreamAlias(value="android:taskAffinity")
    @XStreamAsAttribute
    private String taskAffinity;
    @XStreamAlias(value="android:theme")
    @XStreamAsAttribute
    private String theme;
    @XStreamAlias(value="android:uiOptions")
    @XStreamAsAttribute
    private UIOptions uiOptions;
    @XStreamImplicit(itemFieldName="activity")
    private List<Activity> activities = new ArrayList<Activity>();
    @XStreamImplicit(itemFieldName="activity-alias")
    private List<ActivityAlias> activityAliases = new ArrayList<ActivityAlias>();
    @XStreamImplicit(itemFieldName="service")
    private List<Service> services = new ArrayList<Service>();
    @XStreamImplicit(itemFieldName="receiver")
    private List<Receiver> receivers = new ArrayList<Receiver>();
    @XStreamImplicit(itemFieldName="provider")
    private List<Provider> providers = new ArrayList<Provider>();
    @XStreamImplicit(itemFieldName="uses-library")
    private List<UsesLibrary> usesLibraries = new ArrayList<UsesLibrary>();

    @Merge(value="r")
    public Boolean getAllowTaskReparenting() {
        return this.allowTaskReparenting;
    }

    public void setAllowTaskReparenting(Boolean allowTaskReparenting) {
        this.allowTaskReparenting = allowTaskReparenting;
    }

    @Merge(value="a")
    public String getBackupAgent() {
        return this.backupAgent;
    }

    public void setBackupAgent(String backupAgent) {
        this.backupAgent = backupAgent;
    }

    @Merge(value="b")
    public Boolean getDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(Boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Merge(value="d")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Merge(value="e")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Merge(value="c")
    public Boolean getHasCode() {
        return this.hasCode;
    }

    public void setHasCode(Boolean hasCode) {
        this.hasCode = hasCode;
    }

    @Merge(value="h")
    public Boolean getHardwareAccelerated() {
        return this.hardwareAccelerated;
    }

    public void setHardwareAccelerated(Boolean hardwareAccelerated) {
        this.hardwareAccelerated = hardwareAccelerated;
    }

    @Merge(value="i")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Merge(value="k")
    public Boolean getKillAfterRestore() {
        return this.killAfterRestore;
    }

    public void setKillAfterRestore(Boolean killAfterRestore) {
        this.killAfterRestore = killAfterRestore;
    }

    @Merge(value="l")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Merge(value="o")
    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    @Merge(value="s")
    public String getManageSpaceActivity() {
        return this.manageSpaceActivity;
    }

    public void setManageSpaceActivity(String manageSpaceActivity) {
        this.manageSpaceActivity = manageSpaceActivity;
    }

    @Merge(value="n")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Merge(value="m")
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Merge(value="x")
    public Boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    @Merge(value="p")
    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    @Merge(value="v")
    public Boolean getRestoreAnyVersion() {
        return this.restoreAnyVersion;
    }

    public void setRestoreAnyVersion(Boolean restoreAnyVersion) {
        this.restoreAnyVersion = restoreAnyVersion;
    }

    @Merge(value="f")
    public String getTaskAffinity() {
        return this.taskAffinity;
    }

    public void setTaskAffinity(String taskAffinity) {
        this.taskAffinity = taskAffinity;
    }

    @Merge(value="t")
    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    @Merge(value="u")
    public UIOptions getUiOptions() {
        return this.uiOptions;
    }

    public void setUiOptions(UIOptions uiOptions) {
        this.uiOptions = uiOptions;
    }

    @MergeCollection(collectionType=ArrayList.class, type=Activity.class)
    public List<Activity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<Activity> activities) {
        this.activities = activities;
    }

    public List<ActivityAlias> getActivityAliases() {
        return this.activityAliases;
    }

    public void setActivityAliases(List<ActivityAlias> activityAliases) {
        this.activityAliases = activityAliases;
    }

    @MergeCollection(collectionType=ArrayList.class, type=Service.class)
    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    @MergeCollection(collectionType=ArrayList.class, type=Receiver.class)
    public List<Receiver> getReceivers() {
        return this.receivers;
    }

    public void setReceivers(List<Receiver> receivers) {
        this.receivers = receivers;
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    public void setProviders(List<Provider> providers) {
        this.providers = providers;
    }

    public List<UsesLibrary> getUsesLibraries() {
        return this.usesLibraries;
    }

    public void setUsesLibraries(List<UsesLibrary> usesLibraries) {
        this.usesLibraries = usesLibraries;
    }

    @Override
    public String getIdentifier() {
        return this.name;
    }

    public void updatePackage(String manifestPackage) {
        if (this.name != null && this.name.startsWith(manifestPackage) && this.containsTag("n")) {
            this.name = this.name.substring(manifestPackage.length());
        }
        if (this.activities != null) {
            for (Activity activity : this.activities) {
                activity.updatePackage(manifestPackage);
            }
        }
        if (this.services != null) {
            for (Service service : this.services) {
                service.updatePackage(manifestPackage);
            }
        }
        if (this.receivers != null) {
            for (Receiver receiver : this.receivers) {
                receiver.updatePackage(manifestPackage);
            }
        }
    }
}

