/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.model.manifest;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.androidtransfuse.model.Mergeable;
import org.androidtransfuse.model.manifest.Application;
import org.androidtransfuse.model.manifest.CompatibleScreens;
import org.androidtransfuse.model.manifest.InstallLocation;
import org.androidtransfuse.model.manifest.Instrumentation;
import org.androidtransfuse.model.manifest.Permission;
import org.androidtransfuse.model.manifest.PermissionGroup;
import org.androidtransfuse.model.manifest.PermissionTree;
import org.androidtransfuse.model.manifest.SupportsScreens;
import org.androidtransfuse.model.manifest.UsesConfiguration;
import org.androidtransfuse.model.manifest.UsesFeature;
import org.androidtransfuse.model.manifest.UsesPermission;
import org.androidtransfuse.model.manifest.UsesSDK;
import org.androidtransfuse.processor.MergeCollection;

@XStreamAlias(value="manifest")
public class Manifest
extends Mergeable {
    public static final String NAMESPACE = "http://androidtransfuse.org";
    @XStreamAlias(value="xmlns:t")
    @XStreamAsAttribute
    private String transfuseNamespace;
    @XStreamAlias(value="xmlns:android")
    @XStreamAsAttribute
    private final String namespace = "http://schemas.android.com/apk/res/android";
    @XStreamAlias(value="package")
    @XStreamAsAttribute
    private String applicationPackage;
    @XStreamAlias(value="android:sharedUserId")
    @XStreamAsAttribute
    private String sharedUserId;
    @XStreamAlias(value="android:sharedUserLabel")
    @XStreamAsAttribute
    private String sharedUserLabel;
    @XStreamAlias(value="android:versionCode")
    @XStreamAsAttribute
    private Integer versionCode;
    @XStreamAlias(value="android:versionName")
    @XStreamAsAttribute
    private String versionName;
    @XStreamAlias(value="android:installLocation")
    @XStreamAsAttribute
    private InstallLocation installLocation;
    @XStreamImplicit(itemFieldName="uses-permission")
    private List<UsesPermission> usesPermissions = new ArrayList<UsesPermission>();
    @XStreamImplicit(itemFieldName="uses-sdk")
    private List<UsesSDK> usesSDKs = new ArrayList<UsesSDK>();
    @XStreamImplicit(itemFieldName="application")
    private List<Application> applications = new ArrayList<Application>();
    @XStreamImplicit(itemFieldName="instrumentation")
    private List<Instrumentation> instrumentations = new ArrayList<Instrumentation>();
    @XStreamImplicit(itemFieldName="permission")
    private List<Permission> permissions = new ArrayList<Permission>();
    @XStreamImplicit(itemFieldName="permission-group")
    private List<PermissionGroup> permissionGroups = new ArrayList<PermissionGroup>();
    @XStreamImplicit(itemFieldName="permission-tree")
    private List<PermissionTree> permissionTrees = new ArrayList<PermissionTree>();
    @XStreamImplicit(itemFieldName="supports-screens")
    private List<SupportsScreens> supportsScreens = new ArrayList<SupportsScreens>();
    @XStreamImplicit(itemFieldName="uses-feature")
    private List<UsesFeature> usesFeatures = new ArrayList<UsesFeature>();
    @XStreamImplicit(itemFieldName="uses-configuration")
    private List<UsesConfiguration> usesConfigurations = new ArrayList<UsesConfiguration>();
    @XStreamImplicit(itemFieldName="compatible-screens")
    private List<CompatibleScreens> compatibleScreens = new ArrayList<CompatibleScreens>();

    public String getApplicationPackage() {
        return this.applicationPackage;
    }

    public void setApplicationPackage(String applicationPackage) {
        this.applicationPackage = applicationPackage;
    }

    public void updateNamespace() {
        this.transfuseNamespace = NAMESPACE;
    }

    public String getSharedUserId() {
        return this.sharedUserId;
    }

    public void setSharedUserId(String sharedUserId) {
        this.sharedUserId = sharedUserId;
    }

    public String getSharedUserLabel() {
        return this.sharedUserLabel;
    }

    public void setSharedUserLabel(String sharedUserLabel) {
        this.sharedUserLabel = sharedUserLabel;
    }

    public Integer getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(Integer versionCode) {
        this.versionCode = versionCode;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public InstallLocation getInstallLocation() {
        return this.installLocation;
    }

    public void setInstallLocation(InstallLocation installLocation) {
        this.installLocation = installLocation;
    }

    @MergeCollection(collectionType=ArrayList.class, type=Application.class)
    public List<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(List<Application> applications) {
        this.applications = applications;
    }

    public List<Instrumentation> getInstrumentations() {
        return this.instrumentations;
    }

    public void setInstrumentations(List<Instrumentation> instrumentations) {
        this.instrumentations = instrumentations;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public List<PermissionGroup> getPermissionGroups() {
        return this.permissionGroups;
    }

    public void setPermissionGroups(List<PermissionGroup> permissionGroups) {
        this.permissionGroups = permissionGroups;
    }

    public List<PermissionTree> getPermissionTrees() {
        return this.permissionTrees;
    }

    public void setPermissionTrees(List<PermissionTree> permissionTrees) {
        this.permissionTrees = permissionTrees;
    }

    public List<UsesConfiguration> getUsesConfigurations() {
        return this.usesConfigurations;
    }

    public void setUsesConfigurations(List<UsesConfiguration> usesConfigurations) {
        this.usesConfigurations = usesConfigurations;
    }

    @MergeCollection(collectionType=ArrayList.class, type=UsesPermission.class)
    public List<UsesPermission> getUsesPermissions() {
        return this.usesPermissions;
    }

    public void setUsesPermissions(List<UsesPermission> usesPermissions) {
        this.usesPermissions = usesPermissions;
    }

    @MergeCollection(collectionType=ArrayList.class, type=UsesSDK.class)
    public List<UsesSDK> getUsesSDKs() {
        return this.usesSDKs;
    }

    public void setUsesSDKs(List<UsesSDK> usesSDKs) {
        this.usesSDKs = usesSDKs;
    }

    public List<SupportsScreens> getSupportsScreens() {
        return this.supportsScreens;
    }

    public void setSupportsScreens(List<SupportsScreens> supportsScreens) {
        this.supportsScreens = supportsScreens;
    }

    public List<UsesFeature> getUsesFeatures() {
        return this.usesFeatures;
    }

    public void setUsesFeatures(List<UsesFeature> usesFeatures) {
        this.usesFeatures = usesFeatures;
    }

    public String getNamespace() {
        return "http://schemas.android.com/apk/res/android";
    }

    public String getTransfuseNamespace() {
        return this.transfuseNamespace;
    }

    public List<CompatibleScreens> getCompatibleScreens() {
        return this.compatibleScreens;
    }

    public void setCompatibleScreens(List<CompatibleScreens> compatibleScreens) {
        this.compatibleScreens = compatibleScreens;
    }

    public void updatePackages() {
        if (this.applicationPackage != null) {
            for (Application application : this.applications) {
                application.updatePackage(this.applicationPackage);
            }
        }
    }
}

