/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.model.manifest;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.androidtransfuse.model.Identified;
import org.androidtransfuse.model.Mergeable;
import org.androidtransfuse.model.manifest.IntentFilter;
import org.androidtransfuse.model.manifest.MetaData;
import org.androidtransfuse.processor.Merge;
import org.androidtransfuse.processor.MergeCollection;

public class Receiver
extends Mergeable
implements Comparable<Receiver>,
Identified {
    @XStreamAlias(value="android:enabled")
    @XStreamAsAttribute
    private Boolean enabled;
    @XStreamAlias(value="android:exported")
    @XStreamAsAttribute
    private Boolean exported;
    @XStreamAlias(value="android:icon")
    @XStreamAsAttribute
    private String icon;
    @XStreamAlias(value="android:label")
    @XStreamAsAttribute
    private String label;
    @XStreamAlias(value="android:name")
    @XStreamAsAttribute
    private String name;
    @XStreamAlias(value="android:permission")
    @XStreamAsAttribute
    private String permission;
    @XStreamAlias(value="android:process")
    @XStreamAsAttribute
    private String process;
    @XStreamImplicit(itemFieldName="intent-filter")
    private List<IntentFilter> intentFilters = new ArrayList<IntentFilter>();
    @XStreamImplicit(itemFieldName="meta-data")
    private List<MetaData> metaData = new ArrayList<MetaData>();

    @Merge(value="e")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Merge(value="x")
    public Boolean getExported() {
        return this.exported;
    }

    public void setExported(Boolean exported) {
        this.exported = exported;
    }

    @Merge(value="i")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Merge(value="l")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Merge(value="n")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Merge(value="p")
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Merge(value="r")
    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    @MergeCollection(collectionType=ArrayList.class, type=IntentFilter.class)
    public List<IntentFilter> getIntentFilters() {
        return this.intentFilters;
    }

    public void setIntentFilters(List<IntentFilter> intentFilters) {
        this.intentFilters = intentFilters;
    }

    @MergeCollection(collectionType=ArrayList.class, type=MetaData.class)
    public List<MetaData> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(List<MetaData> metaData) {
        this.metaData = metaData;
    }

    @Override
    public int compareTo(Receiver receiver) {
        return this.getName().compareTo(receiver.getName());
    }

    @Override
    public String getIdentifier() {
        return this.name;
    }

    public void updatePackage(String manifestPackage) {
        if (this.name != null && this.name.startsWith(manifestPackage) && this.containsTag("n")) {
            this.name = this.name.substring(manifestPackage.length());
        }
    }
}

