/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.model.r;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.androidtransfuse.model.r.RResource;
import org.androidtransfuse.model.r.ResourceIdentifier;

public class RResourceComposite
implements RResource {
    private final ImmutableList<RResource> resources;

    public RResourceComposite(RResource ... resources) {
        this.resources = FluentIterable.from(Arrays.asList(resources)).filter(Predicates.notNull()).toImmutableList();
    }

    @Override
    public ResourceIdentifier getResourceIdentifier(Integer id) {
        for (RResource resource : this.resources) {
            ResourceIdentifier identifier = resource.getResourceIdentifier(id);
            if (identifier == null) continue;
            return identifier;
        }
        return null;
    }
}

