/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.model.r;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpression;
import javax.inject.Inject;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.model.r.RResource;
import org.androidtransfuse.model.r.ResourceIdentifier;

public class RResourceReferenceBuilder {
    private final JCodeModel codeModel;
    private final RResource rResource;

    @Inject
    public RResourceReferenceBuilder(JCodeModel codeModel, RResource rResource) {
        this.codeModel = codeModel;
        this.rResource = rResource;
    }

    public JExpression buildReference(Integer id) {
        return this.buildReference(this.rResource.getResourceIdentifier(id));
    }

    public JExpression buildReference(ResourceIdentifier viewResourceIdentifier) {
        ASTType rInnerType = viewResourceIdentifier.getRInnerType();
        JClass rInnerRef = this.codeModel.ref(rInnerType.getName());
        return rInnerRef.staticRef(viewResourceIdentifier.getName());
    }
}

