/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.processor;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.gen.FilerResourceWriter;
import org.androidtransfuse.gen.FilerSourceCodeWriter;
import org.androidtransfuse.processor.CodeGenerationWrapperProvider;
import org.androidtransfuse.processor.ScopedTransactionFactory;
import org.androidtransfuse.transaction.TransactionProcessor;
import org.androidtransfuse.transaction.TransactionProcessorBuilder;
import org.androidtransfuse.transaction.TransactionProcessorPool;
import org.androidtransfuse.transaction.TransactionWorker;

public class AnalysisGenerationTransactionProcessorBuilder
implements TransactionProcessorBuilder<Provider<ASTType>, JDefinedClass> {
    private final ScopedTransactionFactory scopedTransactionFactory;
    private final TransactionProcessorPool<Provider<ASTType>, JDefinedClass> transactionProcessor;
    private final CodeGenerationWrapperProvider<Provider<ASTType>, JDefinedClass> workerProvider;

    @Inject
    public AnalysisGenerationTransactionProcessorBuilder(Provider<TransactionWorker<Provider<ASTType>, JDefinedClass>> workerProvider, Provider<JCodeModel> codeModelProvider, Provider<FilerSourceCodeWriter> sourceCodeWriterProvider, Provider<FilerResourceWriter> resourceCodeWriterProvider, ScopedTransactionFactory scopedTransactionFactory) {
        this.scopedTransactionFactory = scopedTransactionFactory;
        this.transactionProcessor = new TransactionProcessorPool();
        this.workerProvider = new CodeGenerationWrapperProvider<Provider<ASTType>, JDefinedClass>(workerProvider, codeModelProvider, sourceCodeWriterProvider, resourceCodeWriterProvider);
    }

    public void submit(Provider<ASTType> astTypeProvider) {
        this.transactionProcessor.submit(this.scopedTransactionFactory.buildTransaction(astTypeProvider, this.workerProvider));
    }

    public TransactionProcessor<Provider<ASTType>, JDefinedClass> getTransactionProcessor() {
        return this.transactionProcessor;
    }
}

