/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.processor;

import com.sun.codemodel.JDefinedClass;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepository;
import org.androidtransfuse.analysis.repository.InjectionNodeBuilderRepositoryFactory;
import org.androidtransfuse.gen.FactoriesGenerator;
import org.androidtransfuse.gen.variableBuilder.InjectionNodeBuilder;
import org.androidtransfuse.gen.variableBuilder.VariableInjectionBuilderFactory;
import org.androidtransfuse.transaction.AbstractCompletionTransactionWorker;

public class FactoriesTransactionWorker
extends AbstractCompletionTransactionWorker<Map<Provider<ASTType>, JDefinedClass>, Void> {
    private final FactoriesGenerator factoriesGenerator;
    private final InjectionNodeBuilderRepositoryFactory injectionNodeBuilders;
    private final VariableInjectionBuilderFactory variableInjectionBuilderFactory;
    private final Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider;

    @Inject
    public FactoriesTransactionWorker(FactoriesGenerator factoriesGenerator, InjectionNodeBuilderRepositoryFactory injectionNodeBuilders, VariableInjectionBuilderFactory variableInjectionBuilderFactory, Provider<InjectionNodeBuilderRepository> injectionNodeBuilderRepositoryProvider) {
        this.factoriesGenerator = factoriesGenerator;
        this.injectionNodeBuilders = injectionNodeBuilders;
        this.variableInjectionBuilderFactory = variableInjectionBuilderFactory;
        this.injectionNodeBuilderRepositoryProvider = injectionNodeBuilderRepositoryProvider;
    }

    public Void innerRun(Map<Provider<ASTType>, JDefinedClass> aggregate) {
        InjectionNodeBuilderRepository repository = (InjectionNodeBuilderRepository)this.injectionNodeBuilderRepositoryProvider.get();
        for (Provider<ASTType> typeProvider : aggregate.keySet()) {
            ASTType type = (ASTType)typeProvider.get();
            repository.putType(type, (InjectionNodeBuilder)this.variableInjectionBuilderFactory.buildFactoryNodeBuilder(type));
        }
        this.injectionNodeBuilders.addModuleRepository(repository);
        this.factoriesGenerator.generateFactories(aggregate);
        return null;
    }
}

