/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.processor;

import java.io.File;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.androidtransfuse.model.manifest.Application;
import org.androidtransfuse.model.manifest.Manifest;
import org.androidtransfuse.processor.ManifestManager;
import org.androidtransfuse.processor.Merger;
import org.androidtransfuse.processor.MergerException;
import org.androidtransfuse.transaction.AbstractCompletionTransactionWorker;
import org.androidtransfuse.util.Logger;
import org.androidtransfuse.util.ManifestSerializer;

public class GenerateModuleProcessor
extends AbstractCompletionTransactionWorker<Void, Void> {
    private final ManifestManager manifestManager;
    private final Merger merger;
    private final Manifest originalManifest;
    private final Logger logger;
    private final File manifestFile;
    private ManifestSerializer manifestParser;

    @Inject
    public GenerateModuleProcessor(ManifestManager manifestManager, Merger merger, @Named(value="originalManifest") Manifest originalManifest, Logger logger, @Named(value="manifestFile") File manifestFile, ManifestSerializer manifestParser) {
        this.manifestManager = manifestManager;
        this.merger = merger;
        this.originalManifest = originalManifest;
        this.logger = logger;
        this.manifestFile = manifestFile;
        this.manifestParser = manifestParser;
    }

    public Void innerRun(Void value) {
        Manifest updatedManifest = this.buildManifest();
        this.manifestParser.writeManifest(updatedManifest, this.manifestFile);
        return null;
    }

    private Manifest buildManifest() {
        try {
            Manifest manifest = this.manifestManager.getManifest();
            Manifest mergedManifest = this.merger.merge(Manifest.class, this.originalManifest, manifest);
            for (Application application : mergedManifest.getApplications()) {
                Collections.sort(application.getActivities());
            }
            mergedManifest.updatePackages();
            mergedManifest.updateNamespace();
            return mergedManifest;
        }
        catch (MergerException e) {
            this.logger.error("InstantiationException while merging manifest", (Throwable)e);
            return this.originalManifest;
        }
    }
}

