/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.processor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sun.codemodel.JDefinedClass;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.analysis.ActivityAnalysis;
import org.androidtransfuse.analysis.Analysis;
import org.androidtransfuse.analysis.ApplicationAnalysis;
import org.androidtransfuse.analysis.BroadcastReceiverAnalysis;
import org.androidtransfuse.analysis.FragmentAnalysis;
import org.androidtransfuse.analysis.ServiceAnalysis;
import org.androidtransfuse.annotations.Activity;
import org.androidtransfuse.annotations.Application;
import org.androidtransfuse.annotations.BroadcastReceiver;
import org.androidtransfuse.annotations.Factory;
import org.androidtransfuse.annotations.Fragment;
import org.androidtransfuse.annotations.ImplementedBy;
import org.androidtransfuse.annotations.Service;
import org.androidtransfuse.annotations.TransfuseModule;
import org.androidtransfuse.gen.AnalysisGenerationFactory;
import org.androidtransfuse.model.ComponentDescriptor;
import org.androidtransfuse.processor.AnalysisGenerationTransactionProcessorBuilder;
import org.androidtransfuse.processor.AnalysisGenerationTransactionProcessorBuilderFactory;
import org.androidtransfuse.processor.ComponentsTransactionFactory;
import org.androidtransfuse.processor.FactoryProcessor;
import org.androidtransfuse.processor.GenerateModuleProcessor;
import org.androidtransfuse.processor.GeneratorRepository;
import org.androidtransfuse.processor.ImplementedByProcessorBuilder;
import org.androidtransfuse.processor.ModuleProcessorBuilder;
import org.androidtransfuse.processor.PackageHelperTransactionFactory;
import org.androidtransfuse.processor.ScopesUtilityTransactionFactory;
import org.androidtransfuse.processor.VirtualProxyTransactionFactory;
import org.androidtransfuse.transaction.Transaction;
import org.androidtransfuse.transaction.TransactionFactory;
import org.androidtransfuse.transaction.TransactionProcessor;
import org.androidtransfuse.transaction.TransactionProcessorChain;
import org.androidtransfuse.transaction.TransactionProcessorChannel;
import org.androidtransfuse.transaction.TransactionProcessorComposite;
import org.androidtransfuse.transaction.TransactionProcessorPool;
import org.androidtransfuse.transaction.TransactionProcessorPredefined;
import org.androidtransfuse.transaction.TransactionWorker;

public class GeneratorRepositoryProvider
implements Provider<GeneratorRepository> {
    private final FactoryProcessor factoryProcessor;
    private final AnalysisGenerationFactory analysisGenerationFactory;
    private final Provider<ActivityAnalysis> activityAnalysisProvider;
    private final Provider<BroadcastReceiverAnalysis> broadcastReceiverAnalysisProvider;
    private final Provider<ServiceAnalysis> serviceAnalysisProvider;
    private final Provider<FragmentAnalysis> fragmentAnalysisProvider;
    private final Provider<ApplicationAnalysis> applicationAnalysisProvider;
    private final AnalysisGenerationTransactionProcessorBuilderFactory processorFactory;
    private final GenerateModuleProcessor generateModuleProcessor;
    private final PackageHelperTransactionFactory packageHelperTransactionFactory;
    private final ModuleProcessorBuilder moduleProcessorBuilder;
    private final ImplementedByProcessorBuilder implementedByProcessorBuilder;
    private final TransactionProcessorPool<Map<Provider<ASTType>, JDefinedClass>, Void> componentsRepositoryProcessor;
    private final ComponentsTransactionFactory componentsTransactionFactory;
    private final VirtualProxyTransactionFactory virtualProxyTransactionFactory;
    private final ScopesUtilityTransactionFactory scopesUtilityTransactionFactory;

    @Inject
    public GeneratorRepositoryProvider(FactoryProcessor factoryProcessor, AnalysisGenerationFactory analysisGenerationFactory, Provider<ActivityAnalysis> activityAnalysisProvider, Provider<BroadcastReceiverAnalysis> broadcastReceiverAnalysisProvider, Provider<ServiceAnalysis> serviceAnalysisProvider, Provider<FragmentAnalysis> fragmentAnalysisProvider, Provider<ApplicationAnalysis> applicationAnalysisProvider, AnalysisGenerationTransactionProcessorBuilderFactory processorFactory, GenerateModuleProcessor generateModuleProcessor, PackageHelperTransactionFactory packageHelperTransactionFactory, ModuleProcessorBuilder moduleProcessorBuilder, ImplementedByProcessorBuilder implementedByProcessorBuilder, TransactionProcessorPool<Map<Provider<ASTType>, JDefinedClass>, Void> componentsRepositoryProcessor, ComponentsTransactionFactory componentsTransactionFactory, VirtualProxyTransactionFactory virtualProxyTransactionFactory, ScopesUtilityTransactionFactory scopesUtilityTransactionFactory) {
        this.factoryProcessor = factoryProcessor;
        this.analysisGenerationFactory = analysisGenerationFactory;
        this.activityAnalysisProvider = activityAnalysisProvider;
        this.broadcastReceiverAnalysisProvider = broadcastReceiverAnalysisProvider;
        this.serviceAnalysisProvider = serviceAnalysisProvider;
        this.fragmentAnalysisProvider = fragmentAnalysisProvider;
        this.applicationAnalysisProvider = applicationAnalysisProvider;
        this.processorFactory = processorFactory;
        this.generateModuleProcessor = generateModuleProcessor;
        this.packageHelperTransactionFactory = packageHelperTransactionFactory;
        this.moduleProcessorBuilder = moduleProcessorBuilder;
        this.implementedByProcessorBuilder = implementedByProcessorBuilder;
        this.componentsRepositoryProcessor = componentsRepositoryProcessor;
        this.componentsTransactionFactory = componentsTransactionFactory;
        this.virtualProxyTransactionFactory = virtualProxyTransactionFactory;
        this.scopesUtilityTransactionFactory = scopesUtilityTransactionFactory;
    }

    public GeneratorRepository get() {
        ImmutableMap.Builder processorMapBuilder = ImmutableMap.builder();
        ImmutableSet.Builder componentProcessors = ImmutableSet.builder();
        processorMapBuilder.put(TransfuseModule.class, (Object)this.moduleProcessorBuilder);
        processorMapBuilder.put(ImplementedBy.class, (Object)this.implementedByProcessorBuilder);
        TransactionProcessorComposite configurationProcessors = new TransactionProcessorComposite(ImmutableSet.of(this.moduleProcessorBuilder.getTransactionProcessor(), this.implementedByProcessorBuilder.getTransactionProcessor()));
        HashMap<Class<Fragment>, Object> analyzers = new HashMap<Class<Fragment>, Object>();
        analyzers.put(Application.class, this.applicationAnalysisProvider);
        analyzers.put(Activity.class, this.activityAnalysisProvider);
        analyzers.put(BroadcastReceiver.class, this.broadcastReceiverAnalysisProvider);
        analyzers.put(Service.class, this.serviceAnalysisProvider);
        analyzers.put(Fragment.class, this.fragmentAnalysisProvider);
        for (Map.Entry providerEntry : analyzers.entrySet()) {
            Provider<TransactionWorker<Provider<ASTType>, JDefinedClass>> workerProvider = this.analysisGenerationFactory.buildAnalysisGenerationProvider((Provider<? extends Analysis<ComponentDescriptor>>)((Provider)providerEntry.getValue()));
            AnalysisGenerationTransactionProcessorBuilder processorBuilder = this.processorFactory.buildBuilder(workerProvider);
            componentProcessors.add(processorBuilder.getTransactionProcessor());
            processorMapBuilder.put(providerEntry.getKey(), (Object)processorBuilder);
        }
        TransactionProcessorComposite componentsProcessor = new TransactionProcessorComposite(componentProcessors.build());
        TransactionProcessorPredefined manifestProcessor = new TransactionProcessorPredefined(ImmutableSet.of((Object)new Transaction((TransactionWorker)this.generateModuleProcessor)));
        TransactionProcessorChain componentProcessorCompletion = new TransactionProcessorChain((TransactionProcessor)new TransactionProcessorChannel((TransactionProcessor)componentsProcessor, this.componentsRepositoryProcessor, (TransactionFactory)this.componentsTransactionFactory), (TransactionProcessor)manifestProcessor);
        ImmutableSet.Builder configurationDependentBuilders = ImmutableSet.builder();
        configurationDependentBuilders.add(this.factoryProcessor.getTransactionProcessor());
        configurationDependentBuilders.add((Object)componentProcessorCompletion);
        processorMapBuilder.put(Factory.class, (Object)this.factoryProcessor);
        TransactionProcessorPredefined packageHelperProcessor = new TransactionProcessorPredefined(ImmutableSet.of(this.packageHelperTransactionFactory.buildTransaction(), this.virtualProxyTransactionFactory.buildTransaction(), this.scopesUtilityTransactionFactory.buildTransaction()));
        TransactionProcessorComposite configurationDependentProcessors = new TransactionProcessorComposite(configurationDependentBuilders.build());
        TransactionProcessorChain processor = new TransactionProcessorChain((TransactionProcessor)configurationProcessors, (TransactionProcessor)new TransactionProcessorChain((TransactionProcessor)configurationDependentProcessors, (TransactionProcessor)packageHelperProcessor));
        return new GeneratorRepository(processorMapBuilder.build(), (TransactionProcessor)processor);
    }
}

