/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.processor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.model.Mergeable;
import org.androidtransfuse.model.manifest.Activity;
import org.androidtransfuse.model.manifest.Application;
import org.androidtransfuse.model.manifest.IntentFilter;
import org.androidtransfuse.model.manifest.Manifest;
import org.androidtransfuse.model.manifest.MetaData;
import org.androidtransfuse.model.manifest.Receiver;
import org.androidtransfuse.model.manifest.Service;
import org.androidtransfuse.model.manifest.UsesPermission;
import org.androidtransfuse.model.manifest.UsesSDK;
import org.androidtransfuse.processor.Merge;
import org.androidtransfuse.processor.MergerException;
import org.apache.commons.beanutils.PropertyUtils;

@Singleton
public class ManifestManager {
    private Application application;
    private final String manifestPackage;
    private final List<Activity> activities = new ArrayList<Activity>();
    private final List<Receiver> broadcastReceivers = new ArrayList<Receiver>();
    private final List<Service> services = new ArrayList<Service>();
    private final List<UsesPermission> usesPermissions = new ArrayList<UsesPermission>();
    private UsesSDK usesSdk;

    @Inject
    public ManifestManager(@Named(value="originalManifest") Manifest originalManifest) {
        this.manifestPackage = originalManifest.getApplicationPackage();
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void addUsesPermission(String permission) {
        try {
            UsesPermission usesPermission = new UsesPermission(permission);
            this.updateMergeTags(UsesPermission.class, usesPermission);
            this.usesPermissions.add(usesPermission);
        }
        catch (MergerException e) {
            throw new TransfuseAnalysisException("Unable to Merge UsesPermission", (Throwable)e);
        }
    }

    public void setUsesSdk(UsesSDK usesSdk) {
        this.usesSdk = usesSdk;
    }

    public void addActivity(Activity activity) {
        try {
            this.updateMergeTags(Activity.class, activity);
            this.updateMergeTags((Class)IntentFilter.class, (Mergeable)((Object)activity.getIntentFilters()));
            this.updateMergeTags((Class)MetaData.class, (Mergeable)((Object)activity.getMetaData()));
            this.activities.add(activity);
        }
        catch (MergerException e) {
            throw new TransfuseAnalysisException("Unable to Merge Activity", (Throwable)e);
        }
    }

    public void addBroadcastReceiver(Receiver broadcastReceiver) {
        try {
            this.updateMergeTags(Receiver.class, broadcastReceiver);
            this.updateMergeTags((Class)IntentFilter.class, (Mergeable)((Object)broadcastReceiver.getIntentFilters()));
            this.updateMergeTags((Class)MetaData.class, (Mergeable)((Object)broadcastReceiver.getMetaData()));
            this.broadcastReceivers.add(broadcastReceiver);
        }
        catch (MergerException e) {
            throw new TransfuseAnalysisException("Unable to Merge Broadcast Receiver", (Throwable)e);
        }
    }

    private <T extends Mergeable> void updateMergeTags(Class<T> clazz, List<T> mergeableCollection) throws MergerException {
        for (Mergeable mergeable : mergeableCollection) {
            this.updateMergeTags(clazz, mergeable);
        }
    }

    public void addService(Service service) {
        try {
            this.updateMergeTags(Service.class, service);
            this.updateMergeTags((Class)IntentFilter.class, (Mergeable)((Object)service.getIntentFilters()));
            this.updateMergeTags((Class)MetaData.class, (Mergeable)((Object)service.getMetaData()));
            this.services.add(service);
        }
        catch (MergerException e) {
            throw new TransfuseAnalysisException("Unable to Merge Service", (Throwable)e);
        }
    }

    public Manifest getManifest() throws MergerException {
        Manifest manifest = new Manifest();
        manifest.setApplicationPackage(this.manifestPackage);
        Application localApplication = this.application;
        if (this.application == null) {
            localApplication = new Application();
            localApplication.setName(android.app.Application.class.getName());
        }
        this.updateMergeTags(Application.class, localApplication);
        localApplication.getActivities().addAll(this.activities);
        localApplication.getReceivers().addAll(this.broadcastReceivers);
        localApplication.getServices().addAll(this.services);
        manifest.getApplications().add(localApplication);
        manifest.getUsesPermissions().addAll(this.usesPermissions);
        if (this.usesSdk != null) {
            manifest.getUsesSDKs().add(this.usesSdk);
        }
        manifest.updatePackages();
        return manifest;
    }

    private <T extends Mergeable> void updateMergeTags(Class<T> clazz, T mergeable) throws MergerException {
        try {
            mergeable.setGenerated(true);
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                Method readMethod = propertyDescriptor.getReadMethod();
                Method writeMethod = propertyDescriptor.getWriteMethod();
                Merge mergeAnnotation = this.findAnnotation(Merge.class, writeMethod, readMethod);
                Object property = PropertyUtils.getProperty(mergeable, (String)propertyDescriptor.getName());
                if (mergeAnnotation == null || property == null) continue;
                mergeable.addMergeTag(mergeAnnotation.value());
            }
        }
        catch (IntrospectionException e) {
            throw new MergerException(e);
        }
        catch (InvocationTargetException e) {
            throw new MergerException(e);
        }
        catch (NoSuchMethodException e) {
            throw new MergerException(e);
        }
        catch (IllegalAccessException e) {
            throw new MergerException(e);
        }
    }

    private <T extends Annotation> T findAnnotation(Class<T> annotationClass, Method ... methods) {
        T annotation = null;
        if (methods != null) {
            for (Method method : methods) {
                if (annotation != null || method == null || !method.isAnnotationPresent(annotationClass)) continue;
                annotation = method.getAnnotation(annotationClass);
            }
        }
        return annotation;
    }
}

