/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.processor;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.androidtransfuse.processor.MergeableTags;

public class MergeableTagConverter
extends AbstractSingleValueConverter {
    private static final String SPLIT = ",";

    public boolean canConvert(Class type) {
        return MergeableTags.class.isAssignableFrom(type);
    }

    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        Set<String> stringCollection = ((MergeableTags)obj).getTags();
        if (stringCollection.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String s : stringCollection) {
            if (first) {
                first = false;
            } else {
                builder.append(SPLIT);
            }
            builder.append(s);
        }
        return builder.toString();
    }

    public Object fromString(String input) {
        HashSet<String> tagValues = new HashSet<String>();
        if (input != null && !input.isEmpty()) {
            String[] splitInput = input.split(SPLIT);
            tagValues.addAll(Arrays.asList(splitInput));
        }
        return new MergeableTags(tagValues);
    }
}

