/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.processor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.model.Identified;
import org.androidtransfuse.model.Mergeable;
import org.androidtransfuse.processor.Merge;
import org.androidtransfuse.processor.MergeCollection;
import org.androidtransfuse.processor.MergerException;
import org.apache.commons.beanutils.PropertyUtils;

public class Merger {
    public <T> T merge(Class<? extends T> targetClass, T target, T source) throws MergerException {
        if (target == null) {
            return source;
        }
        if (source == null) {
            return target;
        }
        if (!Mergeable.class.isAssignableFrom(targetClass)) {
            return target;
        }
        return (T)this.mergeMergeable(targetClass, (Mergeable)target, (Mergeable)source);
    }

    private <T extends Mergeable> T mergeMergeable(Class<? extends T> targetClass, T target, T source) throws MergerException {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(targetClass);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter = propertyDescriptor.getReadMethod();
                Method setter = propertyDescriptor.getWriteMethod();
                String propertyName = propertyDescriptor.getDisplayName();
                if (!PropertyUtils.isWriteable(target, (String)propertyName)) continue;
                MergeCollection mergeCollection = this.findAnnotation(MergeCollection.class, getter, setter);
                if (Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                    PropertyUtils.setProperty(target, (String)propertyName, (Object)this.mergeList(mergeCollection, propertyName, target, source));
                }
                Merge mergeAnnotation = this.findAnnotation(Merge.class, getter, setter);
                PropertyUtils.setProperty(target, (String)propertyName, (Object)this.mergeProperties(mergeAnnotation, propertyName, target, source));
            }
        }
        catch (NoSuchMethodException e) {
            throw new MergerException("NoSuchMethodException while trying to merge", e);
        }
        catch (IntrospectionException e) {
            throw new MergerException("IntrospectionException while trying to merge", e);
        }
        catch (IllegalAccessException e) {
            throw new MergerException("IllegalAccessException while trying to merge", e);
        }
        catch (InvocationTargetException e) {
            throw new MergerException("InvocationTargetException while trying to merge", e);
        }
        return target;
    }

    private <T extends Annotation> T findAnnotation(Class<T> annotationClass, Method ... methods) {
        T annotation = null;
        if (methods != null) {
            for (Method method : methods) {
                if (annotation != null || method == null || !method.isAnnotationPresent(annotationClass)) continue;
                annotation = method.getAnnotation(annotationClass);
            }
        }
        return annotation;
    }

    private <T extends Mergeable> Object mergeProperties(Merge mergeAnnotation, String propertyName, T target, T source) throws MergerException {
        try {
            String tag = null;
            if (mergeAnnotation != null) {
                tag = mergeAnnotation.value();
            }
            Object targetProperty = PropertyUtils.getProperty(target, (String)propertyName);
            Object sourceProperty = PropertyUtils.getProperty(source, (String)propertyName);
            Class propertyType = PropertyUtils.getPropertyType(target, (String)propertyName);
            Object merged = tag != null && target.isGenerated() && target.containsTag(tag) ? sourceProperty : this.merge(propertyType, targetProperty, sourceProperty);
            this.updateTag(target, tag, merged == null);
            return merged;
        }
        catch (NoSuchMethodException e) {
            throw new MergerException("NoSuchMethodException while trying to merge", e);
        }
        catch (IllegalAccessException e) {
            throw new MergerException("IllegalAccessException while trying to merge", e);
        }
        catch (InvocationTargetException e) {
            throw new MergerException("InvocationTargetException while trying to merge", e);
        }
    }

    private <T extends Mergeable> void updateTag(T target, String tag, boolean remove) {
        if (tag != null) {
            if (remove) {
                target.removeMergeTag(tag);
            } else {
                target.addMergeTag(tag);
            }
        }
    }

    private <T extends Mergeable> List mergeList(MergeCollection mergeCollectionAnnotation, String propertyName, T target, T source) throws MergerException {
        try {
            List targetCollection = (List)PropertyUtils.getProperty(target, (String)propertyName);
            List sourceCollection = (List)PropertyUtils.getProperty(source, (String)propertyName);
            if (mergeCollectionAnnotation == null) {
                return this.merge(PropertyUtils.getPropertyType(target, (String)propertyName), targetCollection, sourceCollection);
            }
            List<Mergeable> merged = this.updateFromSource(targetCollection, sourceCollection, mergeCollectionAnnotation.type());
            List targetResult = this.makeCollection(targetCollection, mergeCollectionAnnotation.collectionType(), target, propertyName);
            targetResult.clear();
            targetResult.addAll(merged);
            return targetResult;
        }
        catch (NoSuchMethodException e) {
            throw new MergerException("NoSuchMethodException while trying to merge", e);
        }
        catch (IllegalAccessException e) {
            throw new MergerException("IllegalAccessException while trying to merge", e);
        }
        catch (InvocationTargetException e) {
            throw new MergerException("InvocationTargetException while trying to merge", e);
        }
    }

    private <T extends Mergeable> List makeCollection(List targetList, Class<? extends List> listType, T target, String propertyName) throws MergerException {
        try {
            if (targetList == null) {
                if (listType != List.class) {
                    return listType.newInstance();
                }
                return (List)PropertyUtils.getPropertyType(target, (String)propertyName).newInstance();
            }
            return targetList;
        }
        catch (NoSuchMethodException e) {
            throw new MergerException("NoSuchMethodException while trying to merge", e);
        }
        catch (IllegalAccessException e) {
            throw new MergerException("IllegalAccessException while trying to merge", e);
        }
        catch (InstantiationException e) {
            throw new MergerException("InstantiationException while trying to merge", e);
        }
        catch (InvocationTargetException e) {
            throw new MergerException("InvocationTargetException while trying to merge", e);
        }
    }

    private List<Mergeable> updateFromSource(List targetList, List sourceList, Class<? extends Mergeable> type) throws MergerException {
        Map<Object, Mergeable> targetMap = this.buildIdentifierMap(targetList);
        Map<Object, Mergeable> sourceMap = this.buildIdentifierMap(sourceList);
        HashSet<Object> originalTargetKeys = new HashSet<Object>(targetMap.keySet());
        try {
            for (Map.Entry<Object, Mergeable> entry : sourceMap.entrySet()) {
                Object sourceKey = entry.getKey();
                if (targetMap.containsKey(sourceKey)) {
                    Mergeable targetValue = targetMap.get(sourceKey);
                    if (targetValue.isGenerated()) {
                        targetMap.put(sourceKey, this.merge(type, targetValue, entry.getValue()));
                    }
                } else {
                    targetMap.put(sourceKey, this.merge(type, type.newInstance(), entry.getValue()));
                }
                originalTargetKeys.remove(sourceKey);
            }
            for (Map.Entry<Object, Mergeable> entry : originalTargetKeys) {
                Mergeable mergeable = targetMap.get(entry);
                if (!mergeable.isGenerated()) continue;
                targetMap.remove(entry);
            }
        }
        catch (IllegalAccessException e) {
            throw new MergerException("IllegalAccessException while trying to merge", e);
        }
        catch (InstantiationException e) {
            throw new MergerException("InstantiationException while trying to merge!", e);
        }
        return new ArrayList<Mergeable>(targetMap.values());
    }

    private Map<Object, Mergeable> buildIdentifierMap(List input) {
        LinkedHashMap<Object, Mergeable> mergeable = new LinkedHashMap<Object, Mergeable>();
        if (input != null) {
            int i = 0;
            for (Object o : input) {
                if (!(o instanceof Mergeable)) {
                    throw new TransfuseAnalysisException("Merge collection failed on type: " + o.getClass().getName());
                }
                Mergeable t = (Mergeable)o;
                Object key = t instanceof Identified ? ((Identified)((Object)t)).getIdentifier() : Integer.valueOf(i);
                mergeable.put(key, t);
                ++i;
            }
        }
        return mergeable;
    }
}

