/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.processor;

import com.sun.codemodel.JDefinedClass;
import java.util.Collection;
import javax.inject.Provider;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.processor.ParcelTransactionFactory;
import org.androidtransfuse.transaction.TransactionProcessor;
import org.androidtransfuse.transaction.TransactionProcessorPool;

public class ParcelProcessor {
    private final TransactionProcessor processor;
    private final TransactionProcessorPool<Provider<ASTType>, JDefinedClass> parcelProcessor;
    private final ParcelTransactionFactory parcelTransactionFactory;

    public ParcelProcessor(TransactionProcessor processor, TransactionProcessorPool<Provider<ASTType>, JDefinedClass> parcelProcessor, ParcelTransactionFactory parcelTransactionFactory) {
        this.processor = processor;
        this.parcelProcessor = parcelProcessor;
        this.parcelTransactionFactory = parcelTransactionFactory;
    }

    public void submit(Collection<Provider<ASTType>> parcels) {
        for (Provider<ASTType> parcel : parcels) {
            this.parcelProcessor.submit(this.parcelTransactionFactory.buildTransaction(parcel));
        }
    }

    public void execute() {
        this.processor.execute();
    }

    public void checkForErrors() {
        if (!this.processor.isComplete()) {
            throw new TransfuseAnalysisException("@Parcel code generation did not complete successfully.", this.processor.getErrors());
        }
    }
}

