/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.processor;

import android.app.Application;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.gen.ManifestBuilder;
import org.androidtransfuse.processor.GeneratorRepository;
import org.androidtransfuse.transaction.TransactionProcessorBuilder;

@Singleton
public class TransfuseProcessor {
    private final GeneratorRepository generatorRepository;
    private final ManifestBuilder manifestBuilder;

    @Inject
    public TransfuseProcessor(GeneratorRepository generatorRepository, ManifestBuilder manifestBuilder) {
        this.generatorRepository = generatorRepository;
        this.manifestBuilder = manifestBuilder;
    }

    public void generateEmptyApplication() {
        this.manifestBuilder.setupManifestApplication(Application.class.getName());
    }

    public void submit(Class<? extends Annotation> componentAnnotation, Collection<Provider<ASTType>> astProviders) {
        for (Provider<ASTType> astProvider : astProviders) {
            TransactionProcessorBuilder<Provider<ASTType>, ?> builder = this.generatorRepository.getComponentBuilder(componentAnnotation);
            if (builder == null) {
                throw new TransfuseAnalysisException("Builder for type " + componentAnnotation.getName() + " not found");
            }
            builder.submit(astProvider);
        }
    }

    public void execute() {
        this.generatorRepository.getProcessor().execute();
    }

    public void checkForErrors() {
        boolean errored = false;
        ImmutableSet.Builder exceptions = ImmutableSet.builder();
        for (TransactionProcessorBuilder<Provider<ASTType>, ?> transactionProcessor : this.generatorRepository.getComponentBuilders().values()) {
            if (transactionProcessor.getTransactionProcessor().isComplete()) continue;
            errored = true;
            exceptions.addAll((Iterable)transactionProcessor.getTransactionProcessor().getErrors());
        }
        if (errored) {
            throw new TransfuseAnalysisException("Code generation did not complete successfully.", exceptions.build());
        }
    }
}

