/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.androidtransfuse.TransfuseAnalysisException;
import org.androidtransfuse.util.Logger;

public class ManifestLocator {
    private static final int MAX_PARENTS_FROM_SOURCE_FOLDER = 10;
    private final Filer filer;
    private final Logger logger;

    @Inject
    public ManifestLocator(Filer filer, Logger logger) {
        this.filer = filer;
        this.logger = logger;
    }

    public File findManifest() {
        try {
            return this.findManifestFileThrowing();
        }
        catch (URISyntaxException e) {
            this.logger.error("URISyntaxException while trying to load manifest", (Throwable)e);
            throw new TransfuseAnalysisException("URISyntaxException while trying to load manifest", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("IOException while trying to load manifest", (Throwable)e);
            throw new TransfuseAnalysisException("IOException while trying to load manifest", (Throwable)e);
        }
    }

    private File findManifestFileThrowing() throws IOException, URISyntaxException {
        JavaFileObject dummySourceFile = this.filer.createSourceFile("dummy" + System.currentTimeMillis(), new Element[0]);
        String dummySourceFilePath = dummySourceFile.toUri().toString();
        if (dummySourceFilePath.startsWith("file:")) {
            if (!dummySourceFilePath.startsWith("file://")) {
                dummySourceFilePath = "file://" + dummySourceFilePath.substring("file:".length());
            }
        } else {
            dummySourceFilePath = "file://" + dummySourceFilePath;
        }
        this.logger.info("Dummy source file: " + dummySourceFilePath);
        URI cleanURI = new URI(dummySourceFilePath);
        File dummyFile = new File(cleanURI);
        File sourcesGenerationFolder = dummyFile.getParentFile();
        File projectRoot = sourcesGenerationFolder.getParentFile();
        File androidManifestFile = new File(projectRoot, "AndroidManifest.xml");
        for (int i = 0; i < 10 && !androidManifestFile.exists() && projectRoot.getParentFile() != null; ++i) {
            projectRoot = projectRoot.getParentFile();
            androidManifestFile = new File(projectRoot, "AndroidManifest.xml");
        }
        if (!androidManifestFile.exists()) {
            throw new IllegalStateException("Could not find the AndroidManifest.xml file, going up from path [" + sourcesGenerationFolder.getAbsolutePath() + "] found using dummy file [" + dummySourceFilePath + "] (max atempts: " + 10 + ")");
        }
        this.logger.info("AndroidManifest.xml file found: " + androidManifestFile.toString());
        return androidManifestFile;
    }
}

