/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.util;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.inject.Inject;
import org.androidtransfuse.model.manifest.Manifest;
import org.androidtransfuse.util.Logger;
import org.androidtransfuse.util.TransfuseInjectionException;

public class ManifestSerializer {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    private final XStream xStream;
    private final Logger logger;

    @Inject
    public ManifestSerializer(XStream xStream, Logger logger) {
        this.xStream = xStream;
        this.logger = logger;
    }

    public Manifest readManifest(File manifestFile) {
        return (Manifest)this.xStream.fromXML(manifestFile);
    }

    public Manifest readManifest(InputStream manifestInputStream) {
        return (Manifest)this.xStream.fromXML(manifestInputStream);
    }

    public void writeManifest(Manifest manifest, OutputStream manifestStream) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(manifestStream, "UTF-8");
            writer.write(XML_HEADER);
            this.xStream.toXML((Object)manifest, (Writer)writer);
        }
        catch (FileNotFoundException e) {
            this.logger.error("FileNotFoundException while writing manifest", (Throwable)e);
            throw new TransfuseInjectionException((Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("IOException while writing manifest", (Throwable)e);
            throw new TransfuseInjectionException((Throwable)e);
        }
    }

    public void writeManifest(Manifest manifest, File manifestFile) {
        try {
            this.writeManifest(manifest, new FileOutputStream(manifestFile));
        }
        catch (IOException e) {
            this.logger.error("IOException while writing manifest", (Throwable)e);
            throw new TransfuseInjectionException((Throwable)e);
        }
    }
}

