/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.metafacades.uml.Entity;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class EntityMetafacadeUtils {
    public static String toSqlName(String modelElementName, Object separator) {
        ExceptionUtils.checkEmpty((String)"modelElementName", (String)modelElementName);
        StringBuffer sqlName = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(StringUtils.uncapitalize((String)modelElementName));
        char character = iterator.first();
        while (character != '\uffff') {
            if (Character.isUpperCase(character)) {
                sqlName.append(separator);
            }
            character = Character.toUpperCase(character);
            sqlName.append(character);
            character = iterator.next();
        }
        return StringEscapeUtils.escapeSql((String)sqlName.toString());
    }

    public static String getSqlNameFromTaggedValue(String prefix, ModelElementFacade element, String name, Short nameMaxLength, Object separator) {
        return EntityMetafacadeUtils.getSqlNameFromTaggedValue(prefix, element, name, nameMaxLength, null, separator);
    }

    public static String getSqlNameFromTaggedValue(ModelElementFacade element, String name, Short nameMaxLength, String suffix, Object separator) {
        return EntityMetafacadeUtils.getSqlNameFromTaggedValue(null, element, name, nameMaxLength, suffix, separator);
    }

    public static String getSqlNameFromTaggedValue(ModelElementFacade element, String name, Short nameMaxLength, Object separator) {
        return EntityMetafacadeUtils.getSqlNameFromTaggedValue(null, element, name, nameMaxLength, null, separator);
    }

    public static String getSqlNameFromTaggedValue(String prefix, ModelElementFacade element, String name, Short nameMaxLength, String suffix, Object separator) {
        if (element != null) {
            Object value = element.findTaggedValue(name);
            StringBuffer buffer = new StringBuffer(StringUtils.trimToEmpty((String)((String)value)));
            if (StringUtils.isEmpty((String)buffer.toString())) {
                buffer = new StringBuffer(EntityMetafacadeUtils.toSqlName(element.getName(), separator));
                suffix = StringUtils.trimToEmpty((String)suffix);
                prefix = StringUtils.trimToEmpty((String)prefix);
                if (nameMaxLength != null) {
                    short maxLength = (short)(nameMaxLength - suffix.length() - prefix.length());
                    buffer = new StringBuffer(EntityMetafacadeUtils.ensureMaximumNameLength(buffer.toString(), new Short(maxLength)));
                }
                if (StringUtils.isNotBlank((String)prefix)) {
                    buffer.insert(0, prefix);
                }
                if (StringUtils.isNotBlank((String)suffix)) {
                    buffer.append(suffix);
                }
            }
            name = buffer.toString();
        }
        return name;
    }

    public static String ensureMaximumNameLength(String name, Short nameMaxLength) {
        if (StringUtils.isNotEmpty((String)name) && nameMaxLength != null) {
            short max = nameMaxLength;
            if (name.length() > max) {
                name = name.substring(0, max);
            }
        }
        return name;
    }

    public static Collection getIdentifiers(Entity entity, boolean follow) {
        ArrayList identifiers = new ArrayList(entity.getAttributes());
        MetafacadeUtils.filterByStereotype(identifiers, UMLProfile.STEREOTYPE_IDENTIFIER);
        return identifiers.isEmpty() && follow && entity.getGeneralization() instanceof Entity ? EntityMetafacadeUtils.getIdentifiers((Entity)entity.getGeneralization(), follow) : identifiers;
    }

    public static String constructSqlTypeName(String typeName, String columnLength) {
        String value = typeName;
        if (StringUtils.isNotEmpty((String)typeName)) {
            int beginChar = 40;
            int endChar = 41;
            int beginIndex = value.indexOf(40);
            int endIndex = value.indexOf(41);
            if (beginIndex != -1 && endIndex != -1 && endIndex > beginIndex) {
                String replacement = value.substring(beginIndex, endIndex) + ')';
                value = StringUtils.replace((String)value, (String)replacement, (String)('(' + columnLength + ')'));
            } else {
                value = value + '(' + columnLength + ')';
            }
        }
        return value;
    }
}

