/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml;

import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class MetafacadeUtils {
    public static Object getElementAsType(Object element, Class type) {
        Class<?> elementClass;
        Object elementAsType = null;
        if (element != null && type != null && type.isAssignableFrom(elementClass = element.getClass())) {
            elementAsType = element;
        }
        return elementAsType;
    }

    public static void filterByStereotype(Collection modelElements, final String stereotype) {
        if (StringUtils.isNotEmpty((String)stereotype)) {
            CollectionUtils.filter((Collection)modelElements, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return ((ModelElementFacade)object).hasStereotype(stereotype);
                }
            });
        }
    }

    public static void filterByType(Collection modelElements, final Class type) {
        if (type != null) {
            CollectionUtils.filter((Collection)modelElements, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return type.isAssignableFrom(object.getClass());
                }
            });
        }
    }

    public static void filterByNotType(Collection modelElements, final Class type) {
        if (type != null) {
            CollectionUtils.filter((Collection)modelElements, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return !type.isAssignableFrom(object.getClass());
                }
            });
        }
    }

    public static String toRelationName(String roleName, String targetRoleName, String separator) {
        if (roleName.compareTo(targetRoleName) <= 0) {
            return roleName + separator + targetRoleName;
        }
        return targetRoleName + separator + roleName;
    }

    public static void sortByFullyQualifiedName(List metafacades) {
        Collections.sort(metafacades, new FullyQualifiedNameComparator());
    }

    private static final class FullyQualifiedNameComparator
    implements Comparator {
        private final Collator collator = Collator.getInstance();

        FullyQualifiedNameComparator() {
            this.collator.setStrength(0);
        }

        public int compare(Object objectA, Object objectB) {
            ModelElementFacade a = (ModelElementFacade)objectA;
            ModelElementFacade b = (ModelElementFacade)objectB;
            return this.collator.compare(a.getFullyQualifiedName() != null ? a.getFullyQualifiedName() : "", b.getFullyQualifiedName() != null ? b.getFullyQualifiedName() : "");
        }
    }
}

