/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.EnumerationFacade;
import org.andromda.metafacades.uml.EnumerationLiteralFacade;
import org.andromda.metafacades.uml.GeneralizableElementFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.PackageFacade;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.metafacades.uml.TemplateParameterFacade;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;

public class UMLMetafacadeUtils {
    private static final Logger logger = Logger.getLogger(UMLMetafacadeUtils.class);
    private static List<String> reservedWords = new ArrayList<String>();
    private static Map<String, String> implCollection = new HashMap<String, String>();
    private static final String namespaceScopeOperator = ".";
    private static final String COMMA = ", ";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String QUESTION = "?";
    private static FastDateFormat df = FastDateFormat.getInstance((String)"MM/dd/yyyy HH:mm:ss");

    public static boolean isType(ClassifierFacade classifier, String typeName) {
        boolean isType = false;
        if (classifier != null && typeName != null) {
            final String type = StringUtils.trimToEmpty((String)typeName);
            String name = StringUtils.trimToEmpty((String)classifier.getFullyQualifiedName(true));
            isType = name.equals(type);
            if (!isType) {
                boolean bl = isType = CollectionUtils.find(classifier.getAllGeneralizations(), (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        String name = StringUtils.trimToEmpty((String)((ModelElementFacade)object).getFullyQualifiedName(true));
                        return name.equals(type);
                    }
                }) != null;
            }
            if (!isType) {
                String lastType = StringUtils.substringAfterLast((String)typeName, (String)":");
                name = StringUtils.trimToEmpty((String)classifier.getFullyQualifiedName(true));
                if (lastType.equalsIgnoreCase(StringUtils.substringAfterLast((String)classifier.getFullyQualifiedName(), (String)":")) || lastType.equalsIgnoreCase(name) || lastType.equalsIgnoreCase(classifier.getFullyQualifiedName())) {
                    isType = true;
                }
            }
        }
        return isType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateReservedWords() {
        List<String> list = reservedWords;
        synchronized (list) {
            if (reservedWords.isEmpty()) {
                reservedWords.add("abstract");
                reservedWords.add("as");
                reservedWords.add("assert");
                reservedWords.add("auto");
                reservedWords.add("bool");
                reservedWords.add("boolean");
                reservedWords.add("break");
                reservedWords.add("byte");
                reservedWords.add("case");
                reservedWords.add("catch");
                reservedWords.add("char");
                reservedWords.add("checked");
                reservedWords.add("class");
                reservedWords.add("const");
                reservedWords.add("continue");
                reservedWords.add("decimal");
                reservedWords.add("default");
                reservedWords.add("delegate");
                reservedWords.add("delete");
                reservedWords.add("deprecated");
                reservedWords.add("do");
                reservedWords.add("double");
                reservedWords.add("else");
                reservedWords.add("enum");
                reservedWords.add("event");
                reservedWords.add("explicit");
                reservedWords.add("export");
                reservedWords.add("extends");
                reservedWords.add("extern");
                reservedWords.add("false");
                reservedWords.add("final");
                reservedWords.add("finally");
                reservedWords.add("fixed");
                reservedWords.add("float");
                reservedWords.add("foreach");
                reservedWords.add("for");
                reservedWords.add("function");
                reservedWords.add("goto");
                reservedWords.add("if");
                reservedWords.add("implements");
                reservedWords.add("implicit");
                reservedWords.add("import");
                reservedWords.add("in");
                reservedWords.add("inline");
                reservedWords.add("instanceof");
                reservedWords.add("int");
                reservedWords.add("interface");
                reservedWords.add("internal");
                reservedWords.add("is");
                reservedWords.add("lock");
                reservedWords.add("long");
                reservedWords.add("namespace");
                reservedWords.add("native");
                reservedWords.add("new");
                reservedWords.add("null");
                reservedWords.add("object");
                reservedWords.add("operator");
                reservedWords.add("out");
                reservedWords.add("override");
                reservedWords.add("package");
                reservedWords.add("params");
                reservedWords.add("private");
                reservedWords.add("property");
                reservedWords.add("protected");
                reservedWords.add("public");
                reservedWords.add("readonly");
                reservedWords.add("ref");
                reservedWords.add("register");
                reservedWords.add("return");
                reservedWords.add("sbyte");
                reservedWords.add("sealed");
                reservedWords.add("short");
                reservedWords.add("signed");
                reservedWords.add("sizeof");
                reservedWords.add("static");
                reservedWords.add("strictfp");
                reservedWords.add("shring");
                reservedWords.add("struct");
                reservedWords.add("super");
                reservedWords.add("switch");
                reservedWords.add("synchronized");
                reservedWords.add("this");
                reservedWords.add("thread");
                reservedWords.add("throw");
                reservedWords.add("throws");
                reservedWords.add("transient");
                reservedWords.add("true");
                reservedWords.add("try");
                reservedWords.add("typedef");
                reservedWords.add("typeof");
                reservedWords.add("uint");
                reservedWords.add("ulong");
                reservedWords.add("unchecked");
                reservedWords.add("union");
                reservedWords.add("unsafe");
                reservedWords.add("unsigned");
                reservedWords.add("ushort");
                reservedWords.add("using");
                reservedWords.add("virtual");
                reservedWords.add("union");
                reservedWords.add("unsigned");
                reservedWords.add("uuid");
                reservedWords.add("var");
                reservedWords.add("void");
                reservedWords.add("volatile");
                reservedWords.add("while");
            }
        }
    }

    public static boolean isReservedWord(String name) {
        boolean reserved = false;
        UMLMetafacadeUtils.populateReservedWords();
        if (StringUtils.isNotBlank((String)name) && reservedWords.contains(name.toLowerCase())) {
            reserved = true;
        }
        return reserved;
    }

    public static String getGetterPrefix(ClassifierFacade type) {
        return type != null && type.isBooleanType() && type.isPrimitive() ? "is" : "get";
    }

    public static String getGetterPrefix(ClassifierFacade type, int lowerBound) {
        return type != null && type.isBooleanType() && (lowerBound > 0 || type.isPrimitive()) ? "is" : "get";
    }

    public static boolean isConstraintKind(String expression, String kind) {
        Pattern pattern = Pattern.compile(".*\\s*" + StringUtils.trimToEmpty((String)kind) + "\\s*\\w*\\s*:.*", 32);
        Matcher matcher = pattern.matcher(StringUtils.trimToEmpty((String)expression));
        return matcher.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImplCollection(String input) {
        Map<String, String> map = implCollection;
        synchronized (map) {
            if (implCollection.isEmpty()) {
                implCollection.put(UMLProfile.COLLECTION_TYPE_NAME.substring(UMLProfile.COLLECTION_TYPE_NAME.lastIndexOf(58) + 1), UMLProfile.COLLECTION_IMPL_TYPE_NAME.substring(UMLProfile.COLLECTION_IMPL_TYPE_NAME.lastIndexOf(58) + 1));
                implCollection.put(UMLProfile.LIST_TYPE_NAME.substring(UMLProfile.LIST_TYPE_NAME.lastIndexOf(58) + 1), UMLProfile.LIST_IMPL_TYPE_NAME.substring(UMLProfile.LIST_IMPL_TYPE_NAME.lastIndexOf(58) + 1));
                implCollection.put(UMLProfile.MAP_TYPE_NAME.substring(UMLProfile.MAP_TYPE_NAME.lastIndexOf(58) + 1), UMLProfile.MAP_IMPL_TYPE_NAME.substring(UMLProfile.MAP_IMPL_TYPE_NAME.lastIndexOf(58) + 1));
                implCollection.put(UMLProfile.ORDERED_MAP_TYPE_NAME.substring(UMLProfile.ORDERED_MAP_TYPE_NAME.lastIndexOf(58) + 1), UMLProfile.ORDERED_MAP_IMPL_TYPE_NAME.substring(UMLProfile.ORDERED_MAP_IMPL_TYPE_NAME.lastIndexOf(58) + 1));
                implCollection.put(UMLProfile.ORDERED_SET_TYPE_NAME.substring(UMLProfile.ORDERED_SET_TYPE_NAME.lastIndexOf(58) + 1), UMLProfile.ORDERED_SET_IMPL_TYPE_NAME.substring(UMLProfile.ORDERED_SET_IMPL_TYPE_NAME.lastIndexOf(58) + 1));
                implCollection.put(UMLProfile.SET_TYPE_NAME.substring(UMLProfile.SET_TYPE_NAME.lastIndexOf(58) + 1), UMLProfile.SET_IMPL_TYPE_NAME.substring(UMLProfile.SET_IMPL_TYPE_NAME.lastIndexOf(58) + 1));
            }
        }
        String collectionImpl = input;
        if (input.indexOf(46) > 0) {
            String collectionType = null;
            String genericType = null;
            String pkg = null;
            if (input.indexOf(60) > 0) {
                collectionType = input.substring(0, input.indexOf(60));
                genericType = input.substring(input.indexOf(60));
                if (genericType.startsWith("<? extends ")) {
                    genericType = '<' + genericType.substring(11);
                }
            } else {
                collectionType = input;
                genericType = "";
            }
            if (collectionType.indexOf(46) > 0) {
                pkg = collectionType.substring(0, collectionType.lastIndexOf(46) + 1);
                collectionType = collectionType.substring(collectionType.lastIndexOf(46) + 1);
            } else {
                pkg = "java.util.";
                logger.warn((Object)("UMLMetafacadeUtils pkg not found for " + collectionType));
            }
            String implType = implCollection.get(collectionType);
            if (implType == null) {
                logger.warn((Object)("UMLMetafacadeUtils colectionImpl not found for " + collectionType));
                collectionImpl = pkg + "ArrayList" + genericType;
            } else {
                collectionImpl = pkg + implType + genericType;
            }
        }
        return collectionImpl;
    }

    public static boolean shouldOutput(ModelElementFacade mef) {
        boolean rtn = true;
        if (mef != null) {
            try {
                PackageFacade pkg = (PackageFacade)mef.getPackage();
                if (mef instanceof PackageFacade) {
                    pkg = (PackageFacade)mef;
                }
                if (mef.hasStereotype(UMLProfile.STEREOTYPE_DOC_ONLY) || mef.hasStereotype(UMLProfile.STEREOTYPE_FUTURE) || mef.hasStereotype(UMLProfile.STEREOTYPE_IGNORE)) {
                    rtn = false;
                }
                if (pkg != null && (pkg.hasStereotype(UMLProfile.STEREOTYPE_DOC_ONLY) || pkg.hasStereotype(UMLProfile.STEREOTYPE_FUTURE) || pkg.hasStereotype(UMLProfile.STEREOTYPE_IGNORE) || pkg.hasStereotype("analysis") || pkg.hasStereotype("perspective") || StringUtils.containsAny((String)pkg.getName(), (String)" `~!@#%^&*()-+={}[]:;<>,?/|") || "PrimitiveTypes".equals(pkg.getName()) || "datatype".equals(pkg.getName()))) {
                    rtn = false;
                }
            }
            catch (Exception ex) {
                logger.error((Object)("UMLMetafacadeUtils.shouldOutput for " + mef.toString() + ' ' + ex.getClass().getName() + ": " + ex.getMessage()));
            }
        }
        return rtn;
    }

    public static String getClassDeclaration(ModelElementFacade facade, boolean enableTemplating) {
        return UMLMetafacadeUtils.getClassDeclaration(facade, facade.getName(), enableTemplating);
    }

    public static String getClassDeclaration(ModelElementFacade facade, String className, boolean enableTemplating) {
        TypeMappings languageMappings;
        if (StringUtils.isBlank((String)className)) {
            className = facade.getName();
        }
        String fullName = StringUtils.trimToEmpty((String)className);
        String packageName = facade.getPackageName(true);
        String metafacadeNamespaceScopeOperator = "::";
        if (StringUtils.isNotBlank((String)packageName)) {
            fullName = packageName + "::" + fullName;
        }
        if ((languageMappings = facade.getLanguageMappings()) != null) {
            fullName = StringUtils.trimToEmpty((String)languageMappings.getTo(fullName));
            fullName = StringUtils.replace((String)fullName, (String)"::", (String)namespaceScopeOperator);
        }
        if (fullName.indexOf(46) > -1) {
            fullName = fullName.substring(fullName.lastIndexOf(46) + 1);
        }
        if (facade.isTemplateParametersPresent() && enableTemplating) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(fullName);
            buffer.append(LT);
            int size = facade.getTemplateParameters().size();
            int i = 1;
            for (TemplateParameterFacade parameter : facade.getTemplateParameters()) {
                if (parameter == null) continue;
                String name = parameter.getValidationName();
                if (name == null && parameter.getParameter() != null) {
                    name = parameter.getParameter().getName();
                }
                buffer.append(name);
                if (i >= size) continue;
                buffer.append(COMMA);
                ++i;
            }
            buffer.append(GT);
            fullName = buffer.toString();
        }
        return fullName;
    }

    public static String getGenericTemplate(ModelElementFacade facade, boolean enableTemplating) {
        String fullName = "";
        if (facade != null && facade.isTemplateParametersPresent() && enableTemplating) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LT);
            Iterator<TemplateParameterFacade> parameterIterator = facade.getTemplateParameters().iterator();
            while (parameterIterator.hasNext()) {
                parameterIterator.next();
                buffer.append(QUESTION);
                if (!parameterIterator.hasNext()) continue;
                buffer.append(COMMA);
            }
            buffer.append(GT);
            fullName = buffer.toString();
        }
        return fullName;
    }

    public static String getFQNameWithoutTemplate(ModelElementFacade facade) {
        TypeMappings languageMappings;
        String fullName = StringUtils.trimToEmpty((String)facade.getName());
        String packageName = facade.getPackageName(true);
        String metafacadeNamespaceScopeOperator = "::";
        if (StringUtils.isNotBlank((String)packageName)) {
            fullName = packageName + "::" + fullName;
        }
        if ((languageMappings = facade.getLanguageMappings()) != null) {
            fullName = StringUtils.trimToEmpty((String)languageMappings.getTo(fullName));
            fullName = StringUtils.replace((String)fullName, (String)"::", (String)namespaceScopeOperator);
        }
        return fullName;
    }

    public static boolean shouldOutput(ModelElementFacade mef, String outletFile, boolean refOutput) {
        boolean rtn = true;
        if (outletFile == null) {
            return rtn;
        }
        rtn = outletFile.endsWith(".ref") && !refOutput ? false : UMLMetafacadeUtils.shouldOutput(mef);
        return rtn;
    }

    public String createConstructor(ModelElementFacade facade) {
        return this.createConstructor(facade, false);
    }

    public String createConstructor(ModelElementFacade facade, boolean useMany) {
        return this.createConstructor(facade, useMany, null);
    }

    public String createConstructor(ModelElementFacade facade, boolean useMany, ModelElementFacade parent) {
        if (facade == null) {
            return "facade was null";
        }
        String rtn = "";
        String toString = "";
        ClassifierFacade type = null;
        String typeName = facade.getFullyQualifiedName();
        String name = facade.getName();
        String defaultValue = "";
        String collectionType = "java.util.ArrayList";
        Boolean isMany = null;
        boolean isEnumeration = false;
        int maxLength = 9999;
        try {
            ModelElementFacade attr;
            String length;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("name=" + name + " typeName=" + typeName + " useMany=" + useMany + " facade=" + facade + " parent=" + parent));
            }
            if ((length = (String)facade.findTaggedValue("andromda_persistence_column_length")) != null && length.length() > 0 && StringUtils.isNumeric((String)length)) {
                maxLength = Integer.parseInt(length);
            } else {
                length = (String)facade.findTaggedValue("andromda_persistence_column_precision");
                if (length != null && length.length() > 0 && StringUtils.isNumeric((String)length)) {
                    maxLength = Integer.parseInt(length);
                } else {
                    length = (String)facade.findTaggedValue("andromda_validation_length");
                    if (length != null && length.length() > 0 && StringUtils.isNumeric((String)length)) {
                        maxLength = Integer.parseInt(length);
                    } else {
                        length = (String)facade.findTaggedValue("andromda_validation_precision");
                        if (length != null && length.length() > 0 && StringUtils.isNumeric((String)length)) {
                            maxLength = Integer.parseInt(length);
                        }
                    }
                }
            }
            if (facade instanceof ClassifierFacade) {
                ClassifierFacade classifier;
                type = classifier = (ClassifierFacade)facade;
                typeName = classifier.getFullyQualifiedName();
            }
            if (facade instanceof AttributeFacade) {
                attr = (AttributeFacade)facade;
                defaultValue = attr.getDefaultValue();
                type = attr.getType();
                typeName = useMany ? attr.getGetterSetterTypeName() : type.getFullyQualifiedName();
                if (attr.getUpper() > 1 || attr.getUpper() == -1) {
                    isMany = true;
                }
            } else if (facade instanceof ParameterFacade) {
                attr = (ParameterFacade)facade;
                defaultValue = attr.getDefaultValue();
                type = attr.getType();
                typeName = type.getFullyQualifiedName();
                if (type.isEnumeration()) {
                    facade = type;
                } else {
                    typeName = useMany ? collectionType + '<' + type.getFullyQualifiedName() + '>' : type.getFullyQualifiedName();
                }
                if (attr.getUpper() > 1 || attr.getUpper() == -1) {
                    isMany = true;
                }
            }
            if (facade instanceof AssociationEndFacade) {
                attr = (AssociationEndFacade)facade;
                type = attr.getType();
                typeName = useMany ? attr.getGetterSetterTypeName() : type.getFullyQualifiedName();
                if (attr.getUpper() > 1 || attr.getUpper() == -1) {
                    isMany = true;
                }
                facade = attr.getType();
            }
            if (parent != null && StringUtils.isEmpty((String)defaultValue) && ("String".equals(typeName) || "java.lang.String".equals(typeName))) {
                for (DependencyFacade dependency : parent.getSourceDependencies()) {
                    if (!dependency.getName().equals(facade.getName())) continue;
                    facade = dependency.getTargetElement();
                    if (facade instanceof ClassifierFacade) {
                        type = (ClassifierFacade)facade;
                    }
                    typeName = facade.getFullyQualifiedName();
                    toString = ".toString()";
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)(parent + " " + facade + " = " + dependency + " type=" + type + " typeName=" + typeName));
                    break;
                }
            }
            if (type instanceof EnumerationFacade) {
                EnumerationFacade enumer = (EnumerationFacade)type;
                Collection<AttributeFacade> literals = enumer.getLiterals();
                if (StringUtils.isEmpty((String)defaultValue) && !literals.isEmpty()) {
                    AttributeFacade attrib;
                    AttributeFacade literal = literals.iterator().next();
                    if (literal instanceof EnumerationLiteralFacade) {
                        EnumerationLiteralFacade enumLiteral = (EnumerationLiteralFacade)((Object)literal);
                        defaultValue = enumLiteral.getValue();
                    } else if (literal instanceof AttributeFacade && (defaultValue = (attrib = literal).getEnumerationValue()) == null) {
                        defaultValue = attrib.getDefaultValue();
                    }
                    defaultValue = StringUtils.remove((String)defaultValue, (String)"\"");
                    defaultValue = enumer.getFullyQualifiedName() + ".fromValue(\"" + defaultValue + "\")";
                } else {
                    defaultValue = enumer.getName() + '.' + defaultValue;
                }
                isEnumeration = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("EnumerationFacade=" + facade + " type=" + type + " literals=" + literals.size() + " default=" + defaultValue));
                }
            }
            if (type != null && type.findTaggedValue("andromda_persistence_lob_type") != null) {
                typeName = String.valueOf(type.findTaggedValue("andromda_persistence_lob_type"));
            }
            if (useMany && (isMany == null || isMany.booleanValue()) && !typeName.endsWith("[]")) {
                rtn = !(typeName = UMLMetafacadeUtils.getImplCollection(typeName)).startsWith("java.util") ? (type.equals("java.util.Collection") || typeName.equals("java.util.List") ? "new " + collectionType + LT + typeName + ">()" : (typeName.equals("java.util.Set") ? "new java.util.HashSet<" + typeName + ">()" : (typeName.equals("java.util.Map") ? "new java.util.HashMap<" + typeName + ">()" : "new " + collectionType + '<' + typeName + ">()"))) : "new " + typeName + "()";
            } else if ("String".equals(typeName) || "java.lang.String".equals(typeName)) {
                if (defaultValue != null && defaultValue.trim().length() > 0) {
                    if (defaultValue.startsWith("\"") || defaultValue.startsWith("'")) {
                        defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                    }
                    if (defaultValue.endsWith("\"") || defaultValue.endsWith("'")) {
                        defaultValue = defaultValue.substring(0, defaultValue.length() - 2);
                    }
                    if (defaultValue.trim().length() > maxLength) {
                        logger.warn((Object)("Attribute default for " + facade.getFullyQualifiedName() + " is longer than max column length " + maxLength));
                        defaultValue = defaultValue.substring(0, maxLength - 1);
                    }
                }
                rtn = '\"' + (StringUtils.isNotBlank((String)defaultValue) ? defaultValue : name) + '\"';
            } else if ("Boolean".equals(typeName) || "java.lang.Boolean".equals(typeName)) {
                rtn = StringUtils.isNotEmpty((String)defaultValue) ? "Boolean." + defaultValue.toUpperCase() : "Boolean.TRUE";
            } else if ("boolean".equals(typeName)) {
                rtn = StringUtils.isNotEmpty((String)defaultValue) ? defaultValue : "true";
            } else if ("int".equals(typeName) || "short".equals(typeName) || "long".equals(typeName) || "byte".equals(typeName) || "float".equals(typeName) || "double".equals(typeName)) {
                rtn = StringUtils.isNotEmpty((String)defaultValue) ? defaultValue : "1";
            } else if ("java.util.Date".equals(typeName)) {
                rtn = "new " + typeName + "()";
            } else if ("java.sql.Timestamp".equals(typeName)) {
                rtn = "new java.sql.Timestamp(System.currentTimeMillis())";
            } else if ("java.util.Calendar".equals(typeName)) {
                rtn = "java.util.Calendar.getInstance()";
            } else if ("char".equals(typeName)) {
                rtn = "'" + (StringUtils.isNotEmpty((String)defaultValue) ? defaultValue : name.substring(0, 1)) + "'";
            } else if ("Character".equals(typeName)) {
                rtn = "new Character('" + (StringUtils.isNotEmpty((String)defaultValue) ? "new Character(" + defaultValue : name.substring(0, 1)) + "')";
            } else if ("Byte".equals(typeName) || "java.lang.Byte".equals(typeName)) {
                rtn = "new Byte(\"" + facade.getName() + "\")";
            } else if ("Short".equals(typeName) || "java.lang.Short".equals(typeName) || "Integer".equals(typeName) || "java.lang.Integer".equals(typeName) || "Long".equals(typeName) || "java.lang.Long".equals(typeName) || "Float".equals(typeName) || "java.lang.Float".equals(typeName) || "Double".equals(typeName) || "java.lang.Double".equals(typeName) || "java.math.BigDecimal".equals(typeName)) {
                rtn = !StringUtils.isEmpty((String)defaultValue) ? typeName + ".valueOf(" + defaultValue + ")" : typeName + ".valueOf(1)";
            } else if ("java.math.BigInteger".equals(typeName)) {
                rtn = !StringUtils.isEmpty((String)defaultValue) ? "java.math.BigInteger.valueOf(" + defaultValue + ')' : "java.math.BigInteger.valueOf(1)";
            } else if ("byte[]".equals(typeName)) {
                rtn = (StringUtils.isNotBlank((String)defaultValue) ? defaultValue : '\"' + name + '\"') + ".getBytes()";
            } else if ("char[]".equals(typeName)) {
                String value;
                String string = value = StringUtils.isNotBlank((String)defaultValue) ? defaultValue : name;
                if (!value.startsWith("\"")) {
                    value = "\"" + value;
                }
                if (!value.endsWith("\"")) {
                    value = value + "\"";
                }
                rtn = value + ".toCharArray()";
            } else if ("String[]".equals(typeName)) {
                rtn = "new String[] { " + (StringUtils.isNotBlank((String)defaultValue) ? defaultValue : '\"' + name + '\"') + " }";
            } else if (isEnumeration) {
                rtn = useMany ? collectionType + '<' + defaultValue + '>' : defaultValue;
            } else if (!StringUtils.isEmpty((String)defaultValue)) {
                rtn = "new " + typeName + '(' + defaultValue + ')';
            } else if (type != null && type.hasStereotype("EmbeddedValue")) {
                rtn = "new " + typeName + "Impl()";
            } else if (type instanceof GeneralizableElementFacade) {
                rtn = typeName.endsWith("[]") ? "{ new " + typeName.substring(0, typeName.length() - 2) + "() }" : "new " + typeName + "()";
                if (type.isAbstract()) {
                    for (GeneralizableElementFacade spec : type.getSpecializations()) {
                        if (spec.getName().equals(type.getName() + "Impl")) {
                            rtn = '(' + type.getName() + ")new " + typeName + "Impl()";
                            break;
                        }
                        rtn = '(' + type.getName() + ")new " + spec.getFullyQualifiedName() + "()";
                    }
                }
                ClassifierFacade generalization = type;
                for (GeneralizableElementFacade spec : generalization.getSpecializations()) {
                    if (!spec.getName().equals(type.getName() + "Impl")) continue;
                    rtn = '(' + type.getName() + ")new " + spec.getFullyQualifiedName() + "Impl()";
                }
            } else {
                rtn = typeName.endsWith("[]") ? "new " + typeName + " { new " + typeName.substring(0, typeName.length() - 2) + "() }" : "new " + typeName + "()";
            }
            rtn = StringUtils.replace((String)rtn, (String)"java.util.Collection", (String)"java.util.ArrayList") + toString;
            rtn = StringUtils.replace((String)rtn, (String)"java.util.Set", (String)"java.util.HashSet") + toString;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("facade=" + facade + " facadeName=" + facade.getName() + " type=" + type + " typeName=" + typeName + " name=" + name + " isMany=" + isMany + " defaultValue=" + defaultValue + " rtn=" + rtn));
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)(e + " facade=" + facade + " facadeName=" + facade.getName() + " parent=" + parent + " type=" + type + " typeName=" + typeName + " name=" + name + " isMany=" + isMany + " defaultValue=" + defaultValue));
            e.printStackTrace();
        }
        return rtn;
    }

    public static boolean isOwningEnd(AssociationEndFacade associationEnd) {
        boolean owning = false;
        AssociationEndFacade otherEnd = associationEnd.getOtherEnd();
        if (BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)otherEnd.findTaggedValue("andromda_persistence_associationEnd_primary")))) {
            owning = true;
        } else if (BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)otherEnd.findTaggedValue("andromda_persistence_associationEnd_primary")))) {
            owning = false;
        } else if (associationEnd.isNavigable() && !otherEnd.isNavigable()) {
            owning = true;
        } else if (!associationEnd.isNavigable() && otherEnd.isNavigable()) {
            owning = false;
        } else if (otherEnd.isAggregation() || otherEnd.isComposition()) {
            owning = false;
        } else if (associationEnd.isAggregation() || associationEnd.isComposition()) {
            owning = true;
        } else if (!associationEnd.isMany() && otherEnd.isMany()) {
            owning = true;
        } else if (associationEnd.isMany() && !otherEnd.isMany()) {
            owning = false;
        } else if (associationEnd.getLower() > 0 && otherEnd.getLower() == 0) {
            owning = true;
        } else if (associationEnd.getName().length() < otherEnd.getName().length()) {
            owning = true;
        } else if (associationEnd.getName().compareTo(otherEnd.getName()) < 0) {
            owning = true;
        }
        return owning;
    }

    public static String getDate(String format) {
        if (df == null || !format.equals(df.getPattern())) {
            df = FastDateFormat.getInstance((String)format);
        }
        return df.format(new Date());
    }

    public static String getDate() {
        return df.format(new Date());
    }
}

