/*
 * Decompiled with CFR 0.152.
 */
package org.antipathy.mvn_scalafmt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.antipathy.mvn_scalafmt.ScalaFormatter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="format")
public class FormatMojo
extends AbstractMojo {
    @Parameter(property="format.configLocation")
    private String configLocation;
    @Parameter(property="format.configRequired")
    private boolean configRequired;
    @Parameter(property="format.parameters")
    private String parameters;
    @Parameter(property="format.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="format.skiptest", defaultValue="false")
    private boolean skipTestSources;
    @Parameter(property="format.skipmain", defaultValue="false")
    private boolean skipSources;
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    private List<File> sourceDirectories;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", required=true)
    private List<File> testSourceDirectories;

    public void execute() throws MojoExecutionException {
        ArrayList<Object> sources = new ArrayList<Object>();
        ArrayList<Object> testSources = new ArrayList<Object>();
        if (!this.skipSources) {
            sources.addAll(this.sourceDirectories);
        }
        if (!this.skipTestSources) {
            testSources.addAll(this.testSourceDirectories);
        }
        if (!this.skip) {
            try {
                ScalaFormatter.format(this.configLocation, this.configRequired, this.parameters, sources, testSources, this.getLog());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error formatting Scala files", e);
            }
        } else {
            this.getLog().info((CharSequence)"Skip flag set, skipping formatting");
        }
    }
}

