/*
 * Decompiled with CFR 0.152.
 */
package org.antipathy.mvn_scalafmt;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.scalafmt.cli.Cli$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.CliOptions$;
import org.scalafmt.cli.CommonOptions;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.config.ScalafmtConfig;
import org.scalafmt.util.AbsoluteFile$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ScalaFormatter$ {
    public static ScalaFormatter$ MODULE$;

    static {
        new ScalaFormatter$();
    }

    public void format(String configLocation, String parameters, List<Object> sourceRoots, List<Object> testSourceRoots, Log log) {
        Seq<String> config = this.parseConfigLocation(configLocation, log);
        Seq<String> params = this.parseParametersString(parameters, log);
        Seq sources = (Seq)this.getSourcePaths((Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(sourceRoots).asScala())).$plus$plus(this.getSourcePaths((Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(testSourceRoots).asScala())), Seq$.MODULE$.canBuildFrom());
        if (sources.nonEmpty()) {
            CliOptions cliOptions = this.getCLiOptions((Seq<String>)sources, config, params);
            log.info((CharSequence)sources.toString());
            log.info((CharSequence)new StringBuilder(11).append("Formatting ").append(sources.mkString(",")).toString());
            Cli$.MODULE$.run(cliOptions);
        } else {
            log.error((CharSequence)"No source files found, skipping formatting!");
        }
    }

    public CliOptions getCLiOptions(Seq<String> sources, Seq<String> config, Seq<String> params) {
        CliOptions cliOptions;
        Seq x$2 = (Seq)sources.flatMap((Function1 & Serializable & scala.Serializable)path -> Option$.MODULE$.option2Iterable(AbsoluteFile$.MODULE$.fromPath(path)), Seq$.MODULE$.canBuildFrom());
        ScalafmtConfig x$3 = CliOptions$.MODULE$.apply$default$1();
        Set x$4 = CliOptions$.MODULE$.apply$default$2();
        Seq x$5 = CliOptions$.MODULE$.apply$default$4();
        WriteMode x$6 = CliOptions$.MODULE$.apply$default$5();
        boolean x$7 = CliOptions$.MODULE$.apply$default$6();
        boolean x$8 = CliOptions$.MODULE$.apply$default$7();
        boolean x$9 = CliOptions$.MODULE$.apply$default$8();
        boolean x$10 = CliOptions$.MODULE$.apply$default$9();
        Option x$11 = CliOptions$.MODULE$.apply$default$10();
        boolean x$12 = CliOptions$.MODULE$.apply$default$11();
        Option x$13 = CliOptions$.MODULE$.apply$default$12();
        String x$14 = CliOptions$.MODULE$.apply$default$13();
        Option x$15 = CliOptions$.MODULE$.apply$default$14();
        CommonOptions x$16 = CliOptions$.MODULE$.apply$default$15();
        Function1 x$17 = CliOptions$.MODULE$.apply$default$16();
        boolean x$18 = CliOptions$.MODULE$.apply$default$17();
        CliOptions options = new CliOptions(x$3, x$4, x$2, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        Option option = Cli$.MODULE$.getConfig((String[])((TraversableOnce)params.$plus$plus(config, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)), options);
        if (option instanceof Some) {
            CliOptions cliConfig;
            Some some = (Some)option;
            cliOptions = cliConfig = (CliOptions)some.value();
        } else if (None$.MODULE$.equals(option)) {
            cliOptions = options;
        } else {
            throw new MatchError((Object)option);
        }
        return cliOptions;
    }

    public Seq<String> getSourcePaths(Seq<Object> paths) {
        return paths == null ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)((TraversableLike)paths.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ScalaFormatter$.$anonfun$getSourcePaths$2(p)));
    }

    public Seq<String> parseConfigLocation(String location, Log log) throws IllegalArgumentException {
        Seq seq;
        if (location == null || location.trim().equals("")) {
            log.info((CharSequence)"No configuration file specified");
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            log.info((CharSequence)new StringBuilder(22).append("Using config at path: ").append(location).toString());
            if (!Files.exists(Paths.get(location, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException(new StringBuilder(24).append("Config path is invalid: ").append(location).toString());
            }
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--config", location}));
        }
        return seq;
    }

    public Seq<String> parseParametersString(String params, Log log) {
        Seq seq;
        if (params == null || params.trim().equals("")) {
            log.info((CharSequence)"No options specified");
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            log.info((CharSequence)new StringBuilder(10).append("Options: ").append(params).append(" ").toString());
            seq = Predef$.MODULE$.wrapRefArray((Object[])params.split(" "));
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$getSourcePaths$2(String p) {
        return Files.exists(Paths.get(p, new String[0]), new LinkOption[0]);
    }

    private ScalaFormatter$() {
        MODULE$ = this;
    }
}

