/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.symtab;

import java.util.Collections;
import java.util.List;
import org.antlr.symtab.BaseScope;
import org.antlr.symtab.Scope;
import org.antlr.symtab.Symbol;
import org.antlr.symtab.Utils;

public abstract class SymbolWithScope
extends BaseScope
implements Symbol,
Scope {
    protected final String name;
    protected int index;

    public SymbolWithScope(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Scope getScope() {
        return this.enclosingScope;
    }

    @Override
    public void setScope(Scope scope) {
        this.setEnclosingScope(scope);
    }

    @Override
    public Scope getParentScope() {
        return this.getEnclosingScope();
    }

    @Override
    public Scope getEnclosingScope() {
        return this.enclosingScope;
    }

    public String getQualifiedName() {
        return this.enclosingScope.getName() + "." + this.name;
    }

    public String getQualifiedName(String scopePathSeparator) {
        return this.enclosingScope.getName() + scopePathSeparator + this.name;
    }

    public String getFullyQualifiedName(String scopePathSeparator) {
        List<Scope> path = this.getEnclosingPathToRoot();
        Collections.reverse(path);
        return Utils.joinScopeNames(path, scopePathSeparator);
    }

    @Override
    public int getInsertionOrderNumber() {
        return this.index;
    }

    @Override
    public void setInsertionOrderNumber(int i) {
        this.index = i;
    }

    @Override
    public int getNumberOfSymbols() {
        return this.symbols.size();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Symbol)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.name.equals(((Symbol)obj).getName());
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }
}

