/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.symtab;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.antlr.symtab.Scope;
import org.antlr.symtab.Symbol;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;

public class Utils {
    public static ParserRuleContext getAncestor(Parser parser, ParserRuleContext ctx, String ruleName) {
        int ruleIndex = parser.getRuleIndex(ruleName);
        return Utils.getAncestor(ctx, ruleIndex);
    }

    public static ParserRuleContext getAncestor(ParserRuleContext t, int ruleIndex) {
        while (t != null) {
            if (t.getRuleIndex() == ruleIndex) {
                return t;
            }
            t = t.getParent();
        }
        return null;
    }

    public static ParserRuleContext getFirstAncestorOfType(ParserRuleContext t, Class<?> clazz) {
        while (t != null) {
            if (t.getClass() == clazz) {
                return t;
            }
            t = t.getParent();
        }
        return null;
    }

    public static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && clazz != Object.class) {
            for (Field f : clazz.getDeclaredFields()) {
                fields.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field[] getAllAnnotatedFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && clazz != Object.class) {
            for (Field f : clazz.getDeclaredFields()) {
                if (f.getAnnotations().length <= 0) continue;
                fields.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static void getAllNestedScopes(Scope scope, List<Scope> scopes) {
        scopes.addAll(scope.getNestedScopedSymbols());
        for (Scope s : scope.getNestedScopedSymbols()) {
            Utils.getAllNestedScopes(s, scopes);
        }
    }

    public static String toScopeStackString(Scope scope, String separator) {
        List<Scope> scopes = scope.getEnclosingPathToRoot();
        return Utils.joinScopeNames(scopes, separator);
    }

    public static String toQualifierString(Scope scope, String separator) {
        List<Scope> scopes = scope.getEnclosingPathToRoot();
        Collections.reverse(scopes);
        return Utils.joinScopeNames(scopes, separator);
    }

    public static String toString(Scope s, int level) {
        StringBuilder buf = new StringBuilder();
        buf.append(Utils.tab(level));
        buf.append(s.getName());
        buf.append("\n");
        ++level;
        if (s != null) {
            for (Symbol symbol : s.getSymbols()) {
                if (symbol instanceof Scope) continue;
                buf.append(Utils.tab(level));
                buf.append(symbol);
                buf.append("\n");
            }
        }
        for (Scope scope : s.getNestedScopedSymbols()) {
            buf.append(Utils.toString(scope, level));
        }
        return buf.toString();
    }

    public static String toString(Scope s) {
        return Utils.toString(s, 0);
    }

    public static <T> T findFirst(List<T> data, Predicate<T> pred) {
        if (data != null) {
            for (T x : data) {
                if (!pred.test(x)) continue;
                return x;
            }
        }
        return null;
    }

    public static <T> List<T> filter(List<T> data, Predicate<T> pred) {
        ArrayList<T> output = new ArrayList<T>();
        if (data != null) {
            for (T x : data) {
                if (!pred.test(x)) continue;
                output.add(x);
            }
        }
        return output;
    }

    public static <T> Set<T> filter(Collection<T> data, Predicate<T> pred) {
        HashSet<T> output = new HashSet<T>();
        for (T x : data) {
            if (!pred.test(x)) continue;
            output.add(x);
        }
        return output;
    }

    public static <T, R> List<R> map(Collection<T> data, Function<T, R> getter) {
        ArrayList<R> output = new ArrayList<R>();
        if (data != null) {
            for (T x : data) {
                output.add(getter.apply(x));
            }
        }
        return output;
    }

    public static <T, R> List<R> map(T[] data, Function<T, R> getter) {
        ArrayList<R> output = new ArrayList<R>();
        if (data != null) {
            for (T x : data) {
                output.add(getter.apply(x));
            }
        }
        return output;
    }

    public static <T> String join(Collection<T> data, String separator) {
        return Utils.join(data.iterator(), separator, "", "");
    }

    public static <T> String join(Collection<T> data, String separator, String left, String right) {
        return Utils.join(data.iterator(), separator, left, right);
    }

    public static <T> String join(Iterator<T> iter, String separator, String left, String right) {
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(separator);
        }
        return left + buf.toString() + right;
    }

    public static <T> String join(T[] array, String separator) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            builder.append(array[i]);
            if (i >= array.length - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String tab(int n) {
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i <= n; ++i) {
            buf.append("    ");
        }
        return buf.toString();
    }

    public static String joinScopeNames(List<Scope> scopes, String separator) {
        if (scopes == null || scopes.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(scopes.get(0).getName());
        for (int i = 1; i < scopes.size(); ++i) {
            Scope s = scopes.get(i);
            buf.append(separator);
            buf.append(s.getName());
        }
        return buf.toString();
    }
}

