/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;

public class Configuration {
    public static final String ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE = "ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_ENVIRONMENT_VARIABLE = "ANTUBLUE_TEST_ENGINE_PROPERTIES";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_SYSTEM_PROPERTY = "antublue.test.engine.properties";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME = ".antublue-test-engine.properties";
    private static final boolean TRACE = "true".equals(System.getenv("ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE"));
    private static Configuration SINGLETON;
    private static final String USER_HOME;
    private final Properties properties = new Properties();

    private Configuration() {
        File file;
        String propertiesFilename = null;
        String value = System.getenv(ANTUBLUE_TEST_ENGINE_PROPERTIES_ENVIRONMENT_VARIABLE);
        if (value != null && !value.trim().isEmpty()) {
            propertiesFilename = value.trim();
        }
        if (propertiesFilename == null && (value = System.getProperty(ANTUBLUE_TEST_ENGINE_PROPERTIES_SYSTEM_PROPERTY)) != null && !value.trim().isEmpty()) {
            propertiesFilename = value.trim();
        }
        if (propertiesFilename == null && (file = new File(ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME)).exists() && file.canRead() && file.isFile()) {
            propertiesFilename = file.getAbsolutePath();
        }
        if (propertiesFilename == null && (file = new File(USER_HOME + "/" + ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME)).exists() && file.canRead() && file.isFile()) {
            propertiesFilename = file.getAbsolutePath();
        }
        this.trace("properties filename [%s]", propertiesFilename);
        if (propertiesFilename != null) {
            this.trace("loading properties filename [%s]", propertiesFilename);
            try (FileReader reader = new FileReader(propertiesFilename);){
                this.properties.load(reader);
                this.trace("properties loaded filename [%s]", propertiesFilename);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized Configuration singleton() {
        if (SINGLETON == null) {
            SINGLETON = new Configuration();
        }
        return SINGLETON;
    }

    public Optional<String> get(String key) {
        String value = this.properties.getProperty(key);
        this.trace("get name [%s] value [%s]", key, value);
        return Optional.ofNullable(value);
    }

    public Optional<String> getOrDefault(String key, String defaultValue) {
        String value = this.properties.getProperty(key, defaultValue);
        this.trace("get name [%s] defaultValue [%s] value [%s]", key, defaultValue, value);
        return Optional.ofNullable(value);
    }

    public Optional<Boolean> getBoolean(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            String string = value.get();
            this.trace("getBoolean name [%s] value [%s]", key, string);
            return Optional.of(Boolean.parseBoolean(string));
        }
        this.trace("getBoolean name [%s] value [%s]", key, null);
        return Optional.empty();
    }

    public Optional<Boolean> getBooleanOrDefault(String key, boolean defaultValue) {
        Optional<String> optional = this.get(key);
        if (optional.isPresent()) {
            String value = optional.get();
            this.trace("getBoolean name [%s] defaultValue [%s] value [%s]", key, defaultValue, value);
            return Optional.of(Boolean.parseBoolean(value));
        }
        this.trace("getBoolean name [%s] defaultValue [%s] value [%s]", key, defaultValue, defaultValue);
        return Optional.of(defaultValue);
    }

    private void trace(String format, Object ... objects) {
        if (TRACE) {
            this.trace(String.format(format, objects));
        }
    }

    private void trace(String message) {
        if (TRACE) {
            System.out.println("[TRACE] " + this.getClass().getName() + " " + message);
        }
    }

    static {
        USER_HOME = System.getProperty("user.home");
    }
}

