/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.antublue.test.engine.internal.Configuration;

public class ConfigurationParameters
implements org.junit.platform.engine.ConfigurationParameters {
    private static final ConfigurationParameters CONFIGURATION_PARAMETERS = new ConfigurationParameters();
    private Configuration configuration = Configuration.singleton();

    private ConfigurationParameters() {
    }

    public static ConfigurationParameters singleton() {
        return CONFIGURATION_PARAMETERS;
    }

    public Optional<String> get(String key) {
        return this.configuration.get(key);
    }

    public Optional<Boolean> getBoolean(String key) {
        return this.configuration.getBoolean(key);
    }

    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        Optional<String> value = this.configuration.get(key);
        if (value.isPresent()) {
            return Optional.ofNullable(transformer.apply(value.get()));
        }
        return Optional.empty();
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }
}

