/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.util.concurrent.CountDownLatch;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.ExecutionRequest;

public class ExecutorContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorContext.class);
    private final ExecutionRequest executionRequest;
    private final CountDownLatch countDownLatch;
    private Object testInstance;

    public ExecutorContext(ExecutionRequest executionRequest, CountDownLatch countDownLatch) {
        this.executionRequest = executionRequest;
        this.countDownLatch = countDownLatch;
    }

    public ExecutionRequest getExecutionRequest() {
        return this.executionRequest;
    }

    public void setTestInstance(Object testInstance) {
        LOGGER.trace("setTestInstance testInstance [%s]", (Object)testInstance.getClass().getName());
        this.testInstance = testInstance;
    }

    public Object getTestInstance() {
        return this.testInstance;
    }

    public void complete() {
        LOGGER.trace("complete()");
        this.countDownLatch.countDown();
    }
}

