/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.AutoCloseAnnotationUtils;
import org.antublue.test.engine.internal.ExecutorContext;
import org.antublue.test.engine.internal.LockAnnotationUtils;
import org.antublue.test.engine.internal.ReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.StateMachine;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class ArgumentTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private static final Object[] NO_ARGS = null;
    private static final ReflectionUtils REFLECTION_UTILS = ReflectionUtils.singleton();
    private final Class<?> testClass;
    private final Argument testArgument;

    ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)REFLECTION_UTILS.getArgumentSupplierMethod(this.testClass)));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    @Override
    public void execute(ExecutorContext executorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        EngineExecutionListener engineExecutionListener = executorContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        Object testInstance = executorContext.getTestInstance();
        ThrowableCollector throwableCollector = new ThrowableCollector();
        LockAnnotationUtils lockAnnotationUtils = LockAnnotationUtils.singleton();
        StateMachine<State> stateMachine = new StateMachine<State>(this.toString(), State.BEGIN);
        stateMachine.mapTransition(State.BEGIN, sm -> {
            try {
                Optional<Field> optional = REFLECTION_UTILS.getArgumentField(this.testClass);
                if (optional.isPresent()) {
                    Field field = optional.get();
                    field.set(testInstance, this.testArgument);
                }
                sm.next(State.SET_FIELD_SUCCESS);
            }
            catch (Throwable t) {
                throwableCollector.accept(t);
                sm.next(State.SET_FIELD_FAIL);
            }
        });
        stateMachine.mapTransition(State.SET_FIELD_SUCCESS, sm -> {
            try {
                List<Method> methods = REFLECTION_UTILS.getBeforeAllMethods(this.testClass);
                for (Method method : methods) {
                    try {
                        lockAnnotationUtils.processLockAnnotations(method);
                        if (REFLECTION_UTILS.acceptsArgument(method, this.testArgument)) {
                            method.invoke(testInstance, this.testArgument);
                            continue;
                        }
                        method.invoke(testInstance, NO_ARGS);
                    }
                    finally {
                        lockAnnotationUtils.processUnlockAnnotations(method);
                    }
                }
                sm.next(State.BEFORE_ALL_SUCCESS);
            }
            catch (Throwable t) {
                throwableCollector.accept(t);
                sm.next(State.BEFORE_ALL_FAIL);
            }
        });
        stateMachine.mapTransition(State.BEFORE_ALL_SUCCESS, sm -> {
            this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> methodTestDescriptor.execute(executorContext));
            sm.next(State.EXECUTE_SUCCESS);
        });
        stateMachine.mapTransition(State.BEFORE_ALL_FAIL, sm -> {
            this.getChildren(MethodTestDescriptor.class).forEach(methodTestDescriptor -> methodTestDescriptor.skip(executorContext));
            sm.next(State.SKIP_SUCCESS);
        });
        stateMachine.mapTransition(stateMachine.asList((State[])new State[]{State.EXECUTE_SUCCESS, State.SKIP_SUCCESS}), sm -> {
            List<Method> methods = REFLECTION_UTILS.getAfterAllMethods(this.testClass);
            for (Method method : methods) {
                try {
                    lockAnnotationUtils.processLockAnnotations(method);
                    if (REFLECTION_UTILS.acceptsArgument(method, this.testArgument)) {
                        method.invoke(testInstance, this.testArgument);
                        continue;
                    }
                    method.invoke(testInstance, NO_ARGS);
                }
                catch (Throwable t) {
                    throwableCollector.accept(t);
                }
                finally {
                    lockAnnotationUtils.processUnlockAnnotations(method);
                }
            }
            if (throwableCollector.isEmpty()) {
                sm.next(State.AFTER_ALL_SUCCESS);
            } else {
                sm.next(State.AFTER_ALL_FAIL);
            }
        });
        stateMachine.mapTransition(stateMachine.asList((State[])new State[]{State.AFTER_ALL_SUCCESS, State.AFTER_ALL_FAIL}), sm -> {
            try {
                Optional<Field> optional = REFLECTION_UTILS.getArgumentField(this.testClass);
                if (optional.isPresent()) {
                    Field field = optional.get();
                    field.set(testInstance, null);
                }
                sm.next(State.CLEAR_FIELD_SUCCESS);
            }
            catch (Throwable t) {
                throwableCollector.accept(t);
                sm.next(State.CLEAR_FIELD_FAILED);
            }
        });
        stateMachine.mapTransition(stateMachine.asList((State[])new State[]{State.CLEAR_FIELD_SUCCESS, State.CLEAR_FIELD_FAILED}), StateMachine::finish);
        stateMachine.run();
        AutoCloseAnnotationUtils.singleton().processAutoCloseAnnotatedFields(testInstance, "@TestEngine.AfterAll", throwableCollector);
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
    }

    private static enum State {
        BEGIN,
        SET_FIELD_SUCCESS,
        SET_FIELD_FAIL,
        BEFORE_ALL_SUCCESS,
        BEFORE_ALL_FAIL,
        EXECUTE_SUCCESS,
        SKIP_SUCCESS,
        CLEAR_FIELD_SUCCESS,
        CLEAR_FIELD_FAILED,
        AFTER_ALL_FAIL,
        AFTER_ALL_SUCCESS;

    }
}

