/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.internal.AutoCloseAnnotationUtils;
import org.antublue.test.engine.internal.ExecutorContext;
import org.antublue.test.engine.internal.LockAnnotationUtils;
import org.antublue.test.engine.internal.ReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.StateMachine;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public final class ClassTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassTestDescriptor.class);
    private static final ReflectionUtils REFLECTION_UTILS = ReflectionUtils.singleton();
    private static final Object[] NO_ARGS = null;
    private final Class<?> testClass;
    private Object testInstance;

    ClassTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass) {
        super(uniqueId, displayName);
        this.testClass = testClass;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public void execute(ExecutorContext executorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        EngineExecutionListener engineExecutionListener = executorContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        LockAnnotationUtils lockAnnotationUtils = LockAnnotationUtils.singleton();
        StateMachine<State> stateMachine = new StateMachine<State>(this.toString(), State.BEGIN);
        stateMachine.mapTransition(State.BEGIN, sm -> {
            try {
                this.testInstance = this.testClass.getDeclaredConstructor(null).newInstance(null);
                executorContext.setTestInstance(this.testInstance);
                sm.next(State.INSTANTIATE_TEST_INSTANCE_SUCCESS);
            }
            catch (Throwable t) {
                throwableCollector.accept(t);
                sm.next(State.INSTANTIATE_TEST_INSTANCE_FAIL);
            }
        });
        stateMachine.mapTransition(State.INSTANTIATE_TEST_INSTANCE_SUCCESS, simpleStateMachine -> {
            try {
                List<Method> methods = REFLECTION_UTILS.getPrepareMethods(this.testClass);
                for (Method method : methods) {
                    try {
                        lockAnnotationUtils.processLockAnnotations(method);
                        method.invoke(this.testInstance, NO_ARGS);
                    }
                    finally {
                        lockAnnotationUtils.processUnlockAnnotations(method);
                    }
                }
                simpleStateMachine.next(State.PREPARE_SUCCESS);
            }
            catch (Throwable t) {
                throwableCollector.accept(t);
                simpleStateMachine.next(State.PREPARE_FAIL);
            }
        });
        stateMachine.mapTransition(State.PREPARE_SUCCESS, simpleStateMachine -> {
            this.getChildren(ArgumentTestDescriptor.class).forEach(argumentTestDescriptor -> argumentTestDescriptor.execute(executorContext));
            stateMachine.next(State.EXECUTE_SUCCESS);
        });
        stateMachine.mapTransition(State.PREPARE_FAIL, sm -> {
            this.getChildren(ArgumentTestDescriptor.class).forEach(argumentTestDescriptor -> {
                LOGGER.trace("skip uniqueId [%s] testClass [%s] testArgument [%s]", argumentTestDescriptor.getUniqueId(), this.testClass.getName(), argumentTestDescriptor.getTestArgument().name());
                argumentTestDescriptor.skip(executorContext);
            });
            sm.next(State.SKIP_SUCCESS);
        });
        StateMachine.Transition transition = sm -> {
            List<Method> methods = REFLECTION_UTILS.getConcludeMethods(this.testClass);
            for (Method method : methods) {
                try {
                    lockAnnotationUtils.processLockAnnotations(method);
                    method.invoke(this.testInstance, NO_ARGS);
                }
                catch (Throwable t) {
                    throwableCollector.accept(t);
                }
                finally {
                    lockAnnotationUtils.processUnlockAnnotations(method);
                }
            }
            if (throwableCollector.isEmpty()) {
                sm.next(State.CONCLUDE_SUCCESS);
            } else {
                sm.next(State.CONCLUDE_FAIL);
            }
        };
        stateMachine.mapTransition(stateMachine.asList((State[])new State[]{State.EXECUTE_SUCCESS, State.SKIP_SUCCESS}), transition);
        stateMachine.mapTransition(stateMachine.asList((State[])new State[]{State.CONCLUDE_SUCCESS, State.CONCLUDE_FAIL}), StateMachine::finish);
        stateMachine.run();
        AutoCloseAnnotationUtils.singleton().processAutoCloseAnnotatedFields(this.testInstance, "@TestEngine.Conclude", throwableCollector);
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
        this.testInstance = null;
        executorContext.complete();
    }

    private static enum State {
        BEGIN,
        INSTANTIATE_TEST_INSTANCE_SUCCESS,
        INSTANTIATE_TEST_INSTANCE_FAIL,
        PREPARE_SUCCESS,
        PREPARE_FAIL,
        EXECUTE_SUCCESS,
        SKIP_SUCCESS,
        CONCLUDE_SUCCESS,
        CONCLUDE_FAIL;

    }
}

