/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.AutoCloseAnnotationUtils;
import org.antublue.test.engine.internal.ExecutorContext;
import org.antublue.test.engine.internal.LockAnnotationUtils;
import org.antublue.test.engine.internal.ReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.StateMachine;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class MethodTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodTestDescriptor.class);
    private static final ReflectionUtils REFLECTION_UTILS = ReflectionUtils.singleton();
    private static final Object[] NO_ARGS = null;
    private final Class<?> testClass;
    private final Argument testArgument;
    private final Method testMethod;

    MethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument, Method testMethod) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
        this.testMethod = testMethod;
        testMethod.setAccessible(true);
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public boolean isTest() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    @Override
    public void execute(ExecutorContext executorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s] testArgument [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name(), this.testMethod.getName());
        EngineExecutionListener engineExecutionListener = executorContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        LockAnnotationUtils lockAnnotationUtils = LockAnnotationUtils.singleton();
        Object testInstance = executorContext.getTestInstance();
        StateMachine<State> stateMachine = new StateMachine<State>(this.toString(), State.BEGIN);
        stateMachine.mapTransition(State.BEGIN, sm -> {
            try {
                List<Method> methods = REFLECTION_UTILS.getBeforeEachMethods(this.testClass);
                for (Method method : methods) {
                    try {
                        lockAnnotationUtils.processLockAnnotations(method);
                        if (REFLECTION_UTILS.acceptsArgument(method, this.testArgument)) {
                            method.invoke(testInstance, this.testArgument);
                            continue;
                        }
                        method.invoke(testInstance, NO_ARGS);
                    }
                    finally {
                        lockAnnotationUtils.processUnlockAnnotations(method);
                    }
                }
                sm.next(State.BEFORE_EACH_SUCCESS);
            }
            catch (Throwable t) {
                throwableCollector.accept(t);
                sm.next(State.BEFORE_EACH_FAIL);
            }
        });
        stateMachine.mapTransition(State.BEFORE_EACH_SUCCESS, sm -> {
            try {
                try {
                    lockAnnotationUtils.processLockAnnotations(this.testMethod);
                    if (REFLECTION_UTILS.acceptsArgument(this.testMethod, this.testArgument)) {
                        this.testMethod.invoke(testInstance, this.testArgument);
                    } else {
                        this.testMethod.invoke(testInstance, NO_ARGS);
                    }
                    sm.next(State.EXECUTE_SUCCESS);
                }
                finally {
                    lockAnnotationUtils.processUnlockAnnotations(this.testMethod);
                }
            }
            catch (Throwable t) {
                throwableCollector.accept(t);
                sm.next(State.EXECUTE_FAIL);
            }
        });
        stateMachine.mapTransition(stateMachine.asList((State[])new State[]{State.BEFORE_EACH_FAIL, State.EXECUTE_SUCCESS, State.EXECUTE_FAIL}), sm -> {
            List<Method> methods = REFLECTION_UTILS.getAfterEachMethods(this.testClass);
            for (Method method : methods) {
                try {
                    lockAnnotationUtils.processLockAnnotations(method);
                    if (REFLECTION_UTILS.acceptsArgument(method, this.testArgument)) {
                        method.invoke(testInstance, this.testArgument);
                        continue;
                    }
                    method.invoke(testInstance, NO_ARGS);
                }
                catch (Throwable t) {
                    throwableCollector.accept(t);
                }
                finally {
                    lockAnnotationUtils.processUnlockAnnotations(method);
                }
            }
            if (throwableCollector.isEmpty()) {
                sm.next(State.AFTER_EACH_SUCCESS);
            } else {
                sm.next(State.AFTER_EACH_FAIL);
            }
        });
        stateMachine.mapTransition(stateMachine.asList((State[])new State[]{State.AFTER_EACH_SUCCESS, State.AFTER_EACH_FAIL}), StateMachine::finish);
        stateMachine.run();
        AutoCloseAnnotationUtils.singleton().processAutoCloseAnnotatedFields(testInstance, "@TestEngine.AfterEach", throwableCollector);
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
    }

    private static enum State {
        BEGIN,
        BEFORE_EACH_SUCCESS,
        BEFORE_EACH_FAIL,
        EXECUTE_SUCCESS,
        EXECUTE_FAIL,
        AFTER_EACH_SUCCESS,
        AFTER_EACH_FAIL;

    }
}

