/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class StateMachine<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachine.class);
    private final Map<T, Transition<T>> map = new HashMap<T, Transition<T>>();
    private final String id;
    private T previous;
    private T current;

    public StateMachine(String id, T begin) {
        LOGGER.trace("StateMachine id [%s] state [%s]", id, begin);
        this.id = id;
        this.previous = begin;
        this.current = begin;
    }

    public void mapTransition(T state, Transition<T> transition) {
        LOGGER.trace("mapTransition state [%s]", (Object)state);
        if (this.map.containsKey(state)) {
            RuntimeException runtimeException = new RuntimeException(String.format("PROGRAMMING ERROR transition already mapped to [%s]", state));
            runtimeException.printStackTrace(System.out);
            System.out.flush();
            throw runtimeException;
        }
        this.map.put(state, transition);
    }

    public void mapTransition(List<T> states, Transition<T> transition) {
        if (LOGGER.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            int count = 0;
            for (T state : states) {
                if (count > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(state.toString());
                ++count;
            }
            stringBuilder.append("]");
            LOGGER.trace("mapTransition states [%s]", (Object)stringBuilder);
        }
        for (T state : states) {
            this.mapTransition(state, transition);
        }
    }

    public String id() {
        return this.id;
    }

    public T previous() {
        return this.previous;
    }

    public T current() {
        return this.current;
    }

    public void next(T next) {
        if (!this.map.containsKey(next)) {
            RuntimeException runtimeException = new RuntimeException(String.format("PROGRAMMING ERROR no transition mapped to [%s]", next));
            runtimeException.printStackTrace(System.out);
            System.out.flush();
            throw runtimeException;
        }
        this.previous = this.current;
        this.current = next;
    }

    public void run() {
        while (this.current != null) {
            LOGGER.trace("run current state [%s]", (Object)this.current);
            this.map.get(this.current).run(this);
        }
    }

    public void finish() {
        LOGGER.trace("finish");
        this.previous = this.current;
        this.current = null;
    }

    public List<T> asList(T ... states) {
        ArrayList<T> list = new ArrayList<T>(states.length);
        for (T state : states) {
            list.add(state);
        }
        return list;
    }

    public String toString() {
        return this.current.toString();
    }

    public static interface Transition<T> {
        public void run(StateMachine<T> var1);
    }
}

