/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.aliyun.oss.util;

import java.io.File;
import java.util.Hashtable;
import org.anyline.aliyun.oss.util.OSSUtil;
import org.anyline.entity.DataRow;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

public class OSSConfig
extends AnylineConfig {
    private static Hashtable<String, AnylineConfig> instances = new Hashtable();
    private static File configDir;
    public static String DEFAULT_ACCESS_ID;
    public static String DEFAULT_ACCESS_SECRET;
    public static String DEFAULT_ENDPOINT;
    public static String DEFAULT_BUCKET;
    public static String DEFAULT_DIR;
    public static int DEFAULT_EXPIRE_SECOND;
    public String ACCESS_ID = DEFAULT_ACCESS_ID;
    public String ACCESS_SECRET = DEFAULT_ACCESS_SECRET;
    public String ENDPOINT = DEFAULT_ENDPOINT;
    public String BUCKET = DEFAULT_BUCKET;
    public String DIR = DEFAULT_DIR;
    public int EXPIRE_SECOND = DEFAULT_EXPIRE_SECOND;
    public static String CONFIG_NAME;

    public static Hashtable<String, AnylineConfig> getInstances() {
        return instances;
    }

    public static void parse(String content) {
        OSSConfig.parse(OSSConfig.class, (String)content, instances, (String[])compatibles);
    }

    public static void init() {
        OSSConfig.load();
    }

    public static void setConfigDir(File dir) {
        configDir = dir;
        OSSConfig.init();
    }

    public static OSSConfig getInstance() {
        return OSSConfig.getInstance("default");
    }

    public static OSSConfig getInstance(String key) {
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (ConfigTable.getReload() > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)ConfigTable.getReload()) {
            OSSConfig.load();
        }
        OSSConfig instance = (OSSConfig)instances.get(key);
        return instance;
    }

    private static synchronized void load() {
        OSSConfig.load(instances, OSSConfig.class, (String)CONFIG_NAME, (String[])new String[0]);
        lastLoadTime = System.currentTimeMillis();
    }

    private static void debug() {
    }

    public static OSSConfig register(String instance, String id, String secret, String endpoint, String bucket, String dir, int expire) {
        DataRow row = new DataRow();
        row.put("ACCESS_ID", (Object)id);
        row.put("ACCESS_SECRET", (Object)secret);
        row.put("ENDPOINT", (Object)endpoint);
        row.put("BUCKET", (Object)bucket);
        row.put("DIR", (Object)dir);
        row.put("EXPIRE_SECOND", (Object)expire);
        OSSConfig config = (OSSConfig)OSSConfig.parse(OSSConfig.class, (String)instance, (DataRow)row, instances, (String[])compatibles);
        OSSUtil.getInstance(instance);
        return config;
    }

    public static OSSConfig register(String instance, String secret, String endpoint, String bucket, String dir, int expire) {
        return OSSConfig.register("default", instance, secret, endpoint, bucket, dir, expire);
    }

    static {
        DEFAULT_ACCESS_ID = "";
        DEFAULT_ACCESS_SECRET = "";
        DEFAULT_ENDPOINT = "";
        DEFAULT_BUCKET = "";
        DEFAULT_DIR = "";
        DEFAULT_EXPIRE_SECOND = 3600;
        CONFIG_NAME = "anyline-aliyun-oss.xml";
        OSSConfig.init();
        OSSConfig.debug();
    }
}

