/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.aliyun.oss.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PolicyConditions;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.anyline.aliyun.oss.util.OSSConfig;
import org.anyline.net.HttpUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSUtil {
    private static final Logger log = LoggerFactory.getLogger(OSSUtil.class);
    private OSSClient client = null;
    private OSSConfig config = null;
    private static Hashtable<String, OSSUtil> instances = new Hashtable();

    public static Hashtable<String, OSSUtil> getInstances() {
        return instances;
    }

    public OSSUtil() {
    }

    public OSSUtil(String endpoint, String bucket, String account, String password) {
        OSSConfig config = new OSSConfig();
        config.ENDPOINT = endpoint;
        config.ACCESS_ID = account;
        config.ACCESS_SECRET = password;
        config.BUCKET = bucket;
        this.config = config;
        this.client = new OSSClient(config.ENDPOINT, config.ACCESS_ID, config.ACCESS_SECRET);
    }

    public static OSSUtil getInstance() {
        return OSSUtil.getInstance("default");
    }

    public OSSClient getClient() {
        return this.client;
    }

    public void setClient(OSSClient client) {
        this.client = client;
    }

    public OSSConfig getConfig() {
        return this.config;
    }

    public void setConfig(OSSConfig config) {
        this.config = config;
    }

    public static OSSUtil getInstance(String key) {
        OSSConfig config;
        OSSUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key)) && null != (config = OSSConfig.getInstance(key))) {
            util = new OSSUtil();
            util.config = config;
            util.client = new OSSClient(config.ENDPOINT, config.ACCESS_ID, config.ACCESS_SECRET);
            instances.put(key, util);
        }
        return util;
    }

    public String upload(File file, String path) {
        if (null == path) {
            path = "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String result = null;
        if (null != file && file.exists() && file.isDirectory()) {
            List files = FileUtil.getAllChildrenFile((File)file, (String[])new String[0]);
            for (File item : files) {
                String itemPath = FileUtil.merge((String[])new String[]{path, item.getAbsolutePath().replace(file.getAbsolutePath(), "")}).replace("\\", "/");
                String url = this.upload(item, itemPath);
                if (null == result) {
                    result = url;
                    continue;
                }
                result = result + "," + url;
            }
        } else {
            result = this.createUrl(path);
            this.client.putObject(this.config.BUCKET, path, file);
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.info("[oss upload file][result:true][file:{}][url:{}]", (Object)file.getAbsolutePath(), (Object)result);
            }
        }
        return result;
    }

    public String upload(URL url, String path) {
        if (null == path) {
            path = "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            this.client.putObject(this.config.BUCKET, path, url.openStream());
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.info("[oss upload file][result:true][file:{}]", (Object)path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.createUrl(path);
    }

    public String upload(InputStream in, String path) {
        if (null == path) {
            path = "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.client.putObject(this.config.BUCKET, path, in);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.info("[oss upload file][result:true][file:{}]", (Object)path);
        }
        return this.createUrl(path);
    }

    public boolean download(File dir) {
        return this.download(dir, "");
    }

    public List<String> list(String prefix) {
        ObjectListing objectListing;
        ArrayList<String> list = new ArrayList<String>();
        if (null == prefix) {
            prefix = "";
        }
        if (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }
        int maxKeys = 200;
        String nextMarker = null;
        do {
            objectListing = this.client.listObjects(new ListObjectsRequest(this.config.BUCKET).withPrefix(prefix).withMarker(nextMarker).withMaxKeys(Integer.valueOf(200)));
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                String key = s.getKey();
                if (key.endsWith("/")) continue;
                list.add(key);
            }
            nextMarker = objectListing.getNextMarker();
        } while (objectListing.isTruncated());
        return list;
    }

    public List<String> list() {
        return this.list("");
    }

    public boolean download(File dir, String prefix) {
        ObjectListing objectListing;
        if (null == prefix) {
            prefix = "";
        }
        if (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }
        int maxKeys = 200;
        String nextMarker = null;
        do {
            objectListing = this.client.listObjects(new ListObjectsRequest(this.config.BUCKET).withPrefix(prefix).withMarker(nextMarker).withMaxKeys(Integer.valueOf(200)));
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                String key = s.getKey();
                if (key.endsWith("/")) continue;
                File file = new File(dir, key);
                File parent = file.getParentFile();
                if (null != parent && !parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    this.client.getObject(new GetObjectRequest(this.config.BUCKET, key), file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_DEBUG || !log.isWarnEnabled()) continue;
                log.info("[oss download file][local:{}][remote:{}]", (Object)file.getAbsolutePath(), (Object)key);
            }
            nextMarker = objectListing.getNextMarker();
        } while (objectListing.isTruncated());
        return true;
    }

    public boolean exists(String path) {
        boolean result = false;
        if (null == path) {
            path = "";
        }
        String key = this.key(path);
        try {
            result = this.client.doesObjectExist(this.config.BUCKET, key);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.info("[check exists][path:{}][key:{}]", (Object)path, (Object)key);
        }
        return result;
    }

    public boolean delete(String path) {
        if (null == path) {
            path = "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        boolean result = false;
        try {
            String key = this.key(path);
            this.client.deleteObject(this.config.BUCKET, key);
            log.info("[oss delete file][result:true][file:{}]", (Object)path);
            result = true;
        }
        catch (Exception e) {
            log.warn("[oss delete file][result:true][file:{}]", (Object)path);
            result = false;
        }
        return result;
    }

    public OSSObject get(String path) {
        if (null == path) {
            path = "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            path = path.replace("http://" + this.config.BUCKET + "." + this.config.ENDPOINT + "/", "");
            return this.client.getObject(this.config.BUCKET, path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getLastModified(String path) {
        if (null == path) {
            path = "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            path = path.replace("http://" + this.config.BUCKET + "." + this.config.ENDPOINT + "/", "");
            OSSObject obj = this.client.getObject(this.config.BUCKET, path);
            if (null == obj) {
                return null;
            }
            return obj.getObjectMetadata().getLastModified();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getLastModified(String path, String format) {
        Date date;
        if (null == path) {
            path = "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (null == (date = this.getLastModified(path))) {
            return "";
        }
        return DateUtil.format((Date)date, (String)format);
    }

    public boolean isExpire(String path, long millisecond) {
        Date date;
        if (null == path) {
            path = "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (null == (date = this.getLastModified(path))) {
            return false;
        }
        return DateUtil.diff((int)14, (Date)date) > millisecond;
    }

    private String createUrl(String path) {
        if (null == path) {
            path = "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String result = "";
        result = "http://" + this.config.BUCKET + "." + this.config.ENDPOINT;
        result = HttpUtil.mergePath((String[])new String[]{result, path});
        return result;
    }

    public Map<String, String> signature(String dir) {
        return this.signature(dir, this.config.EXPIRE_SECOND);
    }

    public Map<String, String> signature(String dir, int second) {
        if (second == 0) {
            second = this.config.EXPIRE_SECOND;
        }
        String host = "";
        host = this.config.BUCKET.startsWith("http") ? this.config.BUCKET + "." + this.config.ENDPOINT : "https://" + this.config.BUCKET + "." + this.config.ENDPOINT;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String postPolicy = this.policy(dir, second);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = this.client.calculatePostSignature(postPolicy);
            result.put("accessid", this.config.ACCESS_ID);
            result.put("policy", encodedPolicy);
            result.put("signature", postSignature);
            result.put("dir", dir);
            result.put("host", host);
            result.put("expire", String.valueOf((System.currentTimeMillis() + (long)(second * 1000)) / 1000L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String policy(String dir, long second) {
        String result = null;
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
        long expireEndTime = System.currentTimeMillis() + second * 1000L;
        Date expiration = new Date(expireEndTime);
        result = this.client.generatePostPolicy(expiration, policyConds);
        return result;
    }

    public String key(String key) {
        if (null != key && key.contains(this.config.ENDPOINT)) {
            key = key.substring(key.indexOf(this.config.ENDPOINT) + this.config.ENDPOINT.length() + 1);
        }
        return key;
    }

    static {
        Hashtable<String, AnylineConfig> configs = OSSConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, OSSUtil.getInstance(key));
        }
    }
}

