/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.seo.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.anyline.net.HttpResponse;
import org.anyline.net.HttpUtil;
import org.anyline.seo.util.BingSeoConfig;
import org.anyline.seo.util.PushResponse;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BingSeoClient {
    private static Logger log = LoggerFactory.getLogger(BingSeoClient.class);
    public BingSeoConfig config = null;
    private static Hashtable<String, BingSeoClient> instances = new Hashtable();

    public static Hashtable<String, BingSeoClient> getInstances() {
        return instances;
    }

    public BingSeoConfig getConfig() {
        return this.config;
    }

    public static BingSeoClient getInstance() {
        return BingSeoClient.getInstance("default");
    }

    public static BingSeoClient getInstance(String key) {
        BingSeoConfig config;
        BingSeoClient client;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (client = instances.get(key)) && null != (config = BingSeoConfig.getInstance(key))) {
            client = new BingSeoClient();
            client.config = config;
            instances.put(key, client);
        }
        return client;
    }

    public PushResponse push(List<String> urls) {
        String api = "https://www.bing.com/webmaster/api.svc/json/SubmitUrlbatch?apikey=" + this.config.KEY;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=utf-8");
        headers.put("Host", "ssl.bing.com");
        StringBuilder builder = new StringBuilder();
        builder.append("{\"siteUrl\":\"").append(this.config.SITE).append("\"");
        builder.append(",\"urlList\":[");
        boolean first = true;
        for (String url : urls) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append("\"").append(url).append("\"");
        }
        builder.append("]}");
        String body = builder.toString();
        HttpResponse response = HttpUtil.post(headers, (String)api, (String)"UTF-8", (HttpEntity)new StringEntity(body, "utf-8"));
        PushResponse result = this.response(response);
        if (!result.isResult()) {
            log.warn("[push bing fail]\n[msg:{}]\n[content:{}]", (Object)result.getMessage(), (Object)body);
        }
        return result;
    }

    public PushResponse push(String url) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(url);
        return this.push(urls);
    }

    private PushResponse response(HttpResponse response) {
        PushResponse result = new PushResponse();
        result.setResult(false);
        String txt = response.getText();
        result.setMessage(txt);
        if (response.getStatus() == 200) {
            result.setResult(true);
            if (txt.contains("ErrorCode")) {
                result.setResult(false);
            } else {
                result.setResult(true);
            }
        }
        return result;
    }

    static {
        Hashtable<String, AnylineConfig> configs = BingSeoConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, BingSeoClient.getInstance(key));
        }
    }
}

