/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.cache.ehcache;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import net.sf.ehcache.CacheManager;
import org.anyline.entity.DataRow;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;

public class EHCacheConfig
extends AnylineConfig {
    private static Hashtable<String, AnylineConfig> instances = new Hashtable();
    public static String CONFIG_NAME = "anyline-ehcache.xml";

    public static Hashtable<String, AnylineConfig> getInstances() {
        return instances;
    }

    public static void parse(String content) {
        CacheManager.create((InputStream)new ByteArrayInputStream(content.getBytes()));
    }

    public static void init() {
        EHCacheConfig.load();
    }

    public static EHCacheConfig getInstance() {
        return EHCacheConfig.getInstance("default");
    }

    public static EHCacheConfig getInstance(String key) {
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        return (EHCacheConfig)instances.get(key);
    }

    private static synchronized void load() {
        EHCacheConfig.load(instances, EHCacheConfig.class, (String)CONFIG_NAME, (String[])new String[0]);
    }

    private static void debug() {
    }

    public static EHCacheConfig register(String instance, DataRow row) {
        EHCacheConfig config = (EHCacheConfig)EHCacheConfig.parse(EHCacheConfig.class, (String)instance, (DataRow)row, instances, (String[])compatibles);
        return config;
    }

    public static EHCacheConfig register(String instance, String key, String secret) {
        DataRow row = new DataRow();
        row.put("ACCESS_KEY", (Object)key);
        row.put("ACCESS_SECRET", (Object)secret);
        EHCacheConfig config = (EHCacheConfig)EHCacheConfig.parse(EHCacheConfig.class, (String)instance, (DataRow)row, instances, (String[])compatibles);
        return config;
    }

    static {
        EHCacheConfig.init();
        EHCacheConfig.debug();
    }
}

