/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.db2;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.SQLAdapter;
import org.anyline.data.run.Run;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.db2")
public class DB2Adapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.jdbc.delimiter.db2:}")
    private String delimiter;

    public JDBCAdapter.DB_TYPE type() {
        return JDBCAdapter.DB_TYPE.DB2;
    }

    public DB2Adapter() {
        this.delimiterFr = "\"";
        this.delimiterTo = "\"";
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public List<String> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, Table> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, DataSet set) throws Exception {
        return super.tables(index, create, catalog, schema, tables, set);
    }

    public LinkedHashMap<String, Table> tables(boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, ResultSet set) throws Exception {
        return super.tables(create, catalog, schema, tables, set);
    }

    public List<String> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, ResultSet set) throws Exception {
        return super.mtables(create, catalog, schema, tables, set);
    }

    public LinkedHashMap<String, MasterTable> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, DataSet set) throws Exception {
        return super.mtables(index, create, catalog, schema, tables, set);
    }

    public List<String> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags, name);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags);
    }

    public LinkedHashMap<String, PartitionTable> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set) throws Exception {
        return super.ptables(total, index, create, master, catalog, schema, tables, set);
    }

    public LinkedHashMap<String, PartitionTable> ptables(boolean create, String catalog, MasterTable master, String schema, LinkedHashMap<String, PartitionTable> tables, ResultSet set) throws Exception {
        return super.ptables(create, catalog, master, schema, tables, set);
    }

    public List<String> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryColumnRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Column> columns(int index, boolean create, Table table, LinkedHashMap<String, Column> columns, DataSet set) throws Exception {
        return super.columns(index, create, table, columns, set);
    }

    public LinkedHashMap<String, Column> columns(boolean create, Table table, LinkedHashMap<String, Column> columns, SqlRowSet set) throws Exception {
        return super.columns(create, table, columns, set);
    }

    public LinkedHashMap<String, Column> columns(boolean create, Table table, LinkedHashMap<String, Column> columns, ResultSet set) throws Exception {
        return super.columns(create, table, columns, set);
    }

    public List<String> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Tag> tags(int index, boolean create, Table table, LinkedHashMap<String, Tag> tags, DataSet set) throws Exception {
        return super.tags(index, create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, SqlRowSet set) throws Exception {
        return super.tags(create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, ResultSet set) throws Exception {
        return super.tags(create, table, tags, set);
    }

    public List<String> buildQueryIndexRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryIndexRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Index> indexs(int index, boolean create, Table table, LinkedHashMap<String, Index> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, ResultSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public List<String> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Constraint> constraints(int index, boolean create, Table table, LinkedHashMap<String, Constraint> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<String> buildCreateRunSQL(Table table) throws Exception {
        List sqls = super.buildCreateRunSQL(table);
        ArrayList<String> list = new ArrayList<String>();
        for (String sql : sqls) {
            list.add(sql.replace("\r\n", "").replace("\n", ""));
        }
        return list;
    }

    public String buildCreateCommentRunSQL(Table table) throws Exception {
        return super.buildCreateCommentRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildRenameRunSQL(Table table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(Table table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return super.checkTableExists(builder, exists);
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",PRIMARY KEY (");
            int idx = 0;
            for (Column pk : pks) {
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (!BasicUtil.isNotEmpty((Object)order)) continue;
                builder.append(" ").append(order);
            }
            ++idx;
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return super.comment(builder, table);
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public List<String> buildCreateRunSQL(MasterTable master) throws Exception {
        return super.buildCreateRunSQL(master);
    }

    public List<String> buildAlterRunSQL(MasterTable master) throws Exception {
        return super.buildAlterRunSQL(master);
    }

    public String buildDropRunSQL(MasterTable master) throws Exception {
        return super.buildDropRunSQL(master);
    }

    public String buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<String> buildCreateRunSQL(PartitionTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(PartitionTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return super.alterColumnKeyword();
    }

    public String buildAddRunSQL(Column column) throws Exception {
        return super.buildAddRunSQL(column);
    }

    public List<String> buildAlterRunSQL(Column column) throws Exception {
        return super.buildAlterRunSQL(column);
    }

    public String buildDropRunSQL(Column column) throws Exception {
        return super.buildDropRunSQL(column);
    }

    public String buildRenameRunSQL(Column column) throws Exception {
        return super.buildRenameRunSQL(column);
    }

    public List<String> buildChangeTypeRunSQL(Column column) throws Exception {
        return super.buildChangeTypeRunSQL(column);
    }

    public String buildChangeDefaultRunSQL(Column column) throws Exception {
        return super.buildChangeDefaultRunSQL(column);
    }

    public String buildChangeNullableRunSQL(Column column) throws Exception {
        return super.buildChangeNullableRunSQL(column);
    }

    public String buildChangeCommentRunSQL(Column column) throws Exception {
        return super.buildChangeCommentRunSQL(column);
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        return super.type(builder, column);
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return super.nullable(builder, column);
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        if (column.isAutoIncrement() == 1) {
            builder.append(" GENERATED BY DEFAULT AS IDENTITY (START WITH ").append(column.getIncrementSeed()).append(",INCREMENT BY ").append(column.getIncrementStep()).append(")");
        }
        return builder;
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        return super.onupdate(builder, column);
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        return super.position(builder, column);
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        return super.comment(builder, column);
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public String buildAddRunSQL(Tag tag) throws Exception {
        return super.buildAddRunSQL(tag);
    }

    public List<String> buildAlterRunSQL(Tag tag) throws Exception {
        return super.buildAlterRunSQL(tag);
    }

    public String buildDropRunSQL(Tag tag) throws Exception {
        return super.buildDropRunSQL(tag);
    }

    public String buildRenameRunSQL(Tag tag) throws Exception {
        return super.buildRenameRunSQL(tag);
    }

    public String buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return super.buildChangeDefaultRunSQL(tag);
    }

    public String buildChangeNullableRunSQL(Tag tag) throws Exception {
        return super.buildChangeNullableRunSQL(tag);
    }

    public String buildChangeCommentRunSQL(Tag tag) throws Exception {
        return super.buildChangeCommentRunSQL(tag);
    }

    public List<String> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return super.buildChangeTypeRunSQL(tag);
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public String buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<String> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public String buildDropRunSQL(Index index) throws Exception {
        return super.buildDropRunSQL(index);
    }

    public String buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public String buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<String> buildAlterRunSQL(Constraint constraint) throws Exception {
        return super.buildAlterRunSQL(constraint);
    }

    public String buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public String buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String buildInValue(JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "CURRENT TIMESTAMP";
        }
        return null;
    }

    public String type2type(String type) {
        return super.type2type(type);
    }

    public String type2class(String type) {
        return super.type2class(type);
    }

    public String concat(String ... args) {
        return this.concatOr(args);
    }
}

