/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.mysql;

import org.anyline.adapter.DataReader;
import org.anyline.data.jdbc.mysql.MySQLGeometryAdapter;
import org.anyline.data.metadata.StandardColumnType;

public enum MySQLReader {
    GeometryReader(new Object[]{StandardColumnType.GEOMETRY}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parse(bytes);
        }
    }),
    PointReader(new Object[]{StandardColumnType.POINT}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parsePoint(bytes);
        }
    }),
    LineReader(new Object[]{StandardColumnType.LINESTRING}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parseLine(bytes);
        }
    }),
    PolygonReader(new Object[]{StandardColumnType.POLYGON}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parsePolygon(bytes);
        }
    }),
    MultiPointReader(new Object[]{StandardColumnType.MULTIPOINT}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parseMultiPoint(bytes);
        }
    }),
    MultiLineReader(new Object[]{StandardColumnType.MULTILINESTRING}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parseMultiLine(bytes);
        }
    }),
    MultiPolygonReader(new Object[]{StandardColumnType.MULTIPOLYGON}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parseMultiPolygon(bytes);
        }
    }),
    GeometryCollectionReader(new Object[]{StandardColumnType.GEOMETRYCOLLECTION}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MySQLGeometryAdapter.parseGeometryCollection(bytes);
        }
    });

    private final Object[] supports;
    private final DataReader reader;

    public Object[] supports() {
        return this.supports;
    }

    public DataReader reader() {
        return this.reader;
    }

    private MySQLReader(Object[] supports, DataReader reader) {
        this.supports = supports;
        this.reader = reader;
    }
}

