/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.neo4j;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.anyline.adapter.EntityAdapter;
import org.anyline.annotation.Component;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.AbstractJDBCAdapter;
import org.anyline.data.jdbc.neo4j.entity.Neo4jRow;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.Join;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.CommandException;
import org.anyline.exception.CommandUpdateException;
import org.anyline.exception.NotSupportException;
import org.anyline.metadata.Column;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Table;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;

@Component(value="anyline.data.jdbc.adapter.neo4j")
public class Neo4jAdapter
extends AbstractJDBCAdapter
implements JDBCAdapter {
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.Neo4j;
    }

    public Neo4jAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
    }

    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, List<String> columns) {
        return super.buildInsertRun(runtime, batch, dest, obj, columns);
    }

    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        int i;
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        builder.append("CREATE ");
        int dataSize = set.size();
        for (i = 0; i < dataSize; ++i) {
            DataRow row = set.getRow(i);
            if (null == row) continue;
            this.insertValue("e" + i, run, dest, row, columns);
            if (i >= dataSize - 1) continue;
            builder.append(",");
        }
        builder.append(" RETURN ");
        for (i = 0; i < dataSize; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(" ID(e").append(i).append(") AS __ID").append(i);
        }
    }

    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.fillInsertContent(runtime, run, dest, set, columns);
            return;
        }
        builder.append("CREATE ");
        int dataSize = list.size();
        int idx = 0;
        for (Object obj : list) {
            this.insertValue("e" + idx, run, dest, obj, columns);
            if (idx < dataSize - 1) {
                builder.append(",");
            }
            ++idx;
        }
        builder.append(" RETURN ");
        for (int i = 0; i < dataSize; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(" ID(e").append(i).append(") AS __ID").append(i);
        }
    }

    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setPrepare((RunPrepare)new DefaultTablePrepare());
        StringBuilder builder = run.getBuilder();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new CommandException("\u672a\u6307\u5b9a\u8868");
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        DataRow row = null;
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            if (row.hasPrimaryKeys() && null != generator) {
                generator.create((Object)row, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
            }
        } else {
            boolean create = EntityAdapterProxy.createPrimaryValue((Object)obj, columns);
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), columns, null);
            }
        }
        LinkedHashMap cols = this.confirmInsertColumns(runtime, dest, obj, configs, columns, false);
        builder.append("CREATE ");
        this.insertValue("e0", (Run)run, dest, obj, cols);
        builder.append(" RETURN ID(e0) AS __ID0");
        return run;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        if (null == list || list.isEmpty()) {
            throw new CommandException("\u7a7a\u6570\u636e");
        }
        DataRow first = null;
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            first = set.getRow(0);
            if (BasicUtil.isEmpty((Object)dest)) {
                dest = configs.table();
            }
        } else {
            first = (DataRow)list.iterator().next();
            if (BasicUtil.isEmpty((Object)dest)) {
                dest = EntityAdapterProxy.table(first.getClass());
            }
        }
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new CommandException("\u672a\u6307\u5b9a\u8868");
        }
        LinkedHashMap cols = this.confirmInsertColumns(runtime, dest, first, configs, columns, true);
        this.fillInsertContent(runtime, (Run)run, dest, list, cols);
        return run;
    }

    protected void insertValue(String alias, Run run, Table dest, Object obj, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        builder.append("(");
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(alias);
        }
        builder.append(":").append(dest.getName());
        builder.append("{");
        ArrayList<String> insertColumns = new ArrayList<String>();
        boolean first = true;
        for (Column column : columns.values()) {
            String key = column.getName();
            if (!first) {
                builder.append(",");
            }
            first = false;
            Object value = null;
            value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
            this.delimiter(builder, key).append(":");
            if (BasicUtil.checkEl((String)(value + ""))) {
                String str = value.toString();
                if (BasicUtil.checkEl((String)((value = str.substring(2, str.length() - 1)) + ""))) {
                    builder.append("?");
                    insertColumns.add(key);
                    run.addValues(Compare.EQUAL, column, value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
                    continue;
                }
                builder.append(value);
                continue;
            }
            builder.append("?");
            insertColumns.add(key);
            if ("NULL".equals(value)) {
                run.addValues(Compare.EQUAL, column, null, ConfigTable.IS_AUTO_SPLIT_ARRAY);
                continue;
            }
            run.addValues(Compare.EQUAL, column, value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
        }
        builder.append("})");
        run.setInsertColumns(insertColumns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        Connection con;
        DataSource datasource;
        long cnt;
        block16: {
            cnt = 0L;
            datasource = null;
            con = null;
            if (!run.isValid()) {
                if (ConfigTable.IS_LOG_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + run.getTable() + "]");
                }
                return -1L;
            }
            String sql = run.getFinalInsert();
            if (BasicUtil.isEmpty((Object)sql)) {
                log.warn("[\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:{}]", (Object)run.getTable());
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            List values = run.getValues();
            long fr = System.currentTimeMillis();
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[cmd:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)values)});
            }
            long millis = -1L;
            try {
                datasource = this.actuator.getDataSource((DriverAdapter)this, runtime);
                con = this.actuator.getConnection((DriverAdapter)this, runtime, datasource);
                PreparedStatement ps = con.prepareStatement(sql);
                int idx = 0;
                if (null != values) {
                    for (Object obj : values) {
                        ps.setObject(++idx, obj);
                    }
                }
                ResultSet rs = ps.executeQuery();
                if (data instanceof Collection) {
                    ArrayList<Object> ids = new ArrayList<Object>();
                    Collection list = (Collection)data;
                    if (rs.next()) {
                        for (Object item : list) {
                            Object id = rs.getObject("__ID" + cnt);
                            ids.add(id);
                            this.setPrimaryValue(item, id);
                            ++cnt;
                        }
                    }
                    log.info("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, ids);
                    break block16;
                }
                if (!rs.next()) break block16;
                ++cnt;
                Object id = rs.getObject("__ID0");
                this.setPrimaryValue(data, id);
                log.info("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, id);
            }
            catch (Exception e) {
                block17: {
                    try {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            log.error("insert exception:", (Throwable)e);
                        }
                        if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                            CommandUpdateException ex = new CommandUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                            ex.setCmd(sql);
                            ex.setValues(values);
                            throw ex;
                        }
                        if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block17;
                        log.error("{}[{}][cmd:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param((List)run.getInsertColumns(), (List)values)});
                    }
                    catch (Throwable throwable) {
                        this.actuator.releaseConnection((DriverAdapter)this, runtime, con, datasource);
                        throw throwable;
                    }
                }
                this.actuator.releaseConnection((DriverAdapter)this, runtime, con, datasource);
            }
        }
        this.actuator.releaseConnection((DriverAdapter)this, runtime, con, datasource);
        return cnt;
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        if (!(run instanceof TableRun)) {
            return run.getBaseQuery();
        }
        StringBuilder builder = new StringBuilder();
        RunPrepare prepare = run.getPrepare();
        builder.append(run.getBaseQuery());
        String cols = run.getQueryColumn();
        String alias = run.getPrepare().getAlias();
        OrderStore orders = run.getOrderStore();
        if (null != orders) {
            builder.append(orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo()));
        }
        builder.append(" RETURN ");
        LinkedHashMap columns = prepare.getColumns();
        if (null != columns && columns.size() > 0) {
            boolean first = true;
            for (Column column : columns.values()) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (!first) {
                    builder.append(",");
                }
                first = false;
                String name = column.getName();
                if (BasicUtil.checkEl((String)name)) {
                    name = name.substring(2, name.length() - 1);
                    builder.append(name);
                    continue;
                }
                if (name.contains("(") || name.contains(",")) {
                    builder.append(name);
                    continue;
                }
                if (name.toUpperCase().contains(" AS ")) {
                    builder.append(name);
                    continue;
                }
                if ("*".equals(name)) {
                    builder.append("*");
                    continue;
                }
                this.delimiter(builder, alias + "." + name);
            }
            builder.append("\n");
        } else {
            builder.append(alias);
            builder.append("\n");
        }
        builder.append(", ID(").append(alias).append(") AS __ID");
        PageNavi navi = run.getPageNavi();
        if (null != navi) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            builder.append(" SKIP ").append(navi.getFirstRow()).append(" LIMIT ").append(limit);
        }
        String content = builder.toString();
        return content;
    }

    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder) {
        if (compare == Compare.LIKE) {
            builder.append(" CONTAINS ?");
        } else if (compare == Compare.LIKE_PREFIX || compare == Compare.START_WITH) {
            builder.append(" STARTS WITH ?");
        } else if (compare == Compare.LIKE_SUFFIX || compare == Compare.END_WITH) {
            builder.append(" ENDS WITH ?");
        }
        RunValue run = new RunValue();
        run.setValue(value);
        return run;
    }

    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, boolean placeholder) throws NotSupportException {
        return null;
    }

    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder) {
        if (compare == Compare.NOT_IN) {
            builder.append(" NOT");
        }
        builder.append(" IN [");
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                builder.append("?");
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else {
            builder.append("= ?");
        }
        return builder;
    }

    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        List<Map<String, Object>> result = list;
        if (null != list && !list.isEmpty()) {
            Map<String, Object> map = list.get(0);
            Set<String> keys = map.keySet();
            String id_key = "__ID";
            boolean mapHashIdKey = BasicUtil.containsString((boolean)true, (boolean)true, keys, (String)"__ID");
            if (2 == keys.size() && keys.contains(id_key) || keys.size() == 1) {
                Object chk;
                String key = null;
                for (String k : keys) {
                    if (id_key.equalsIgnoreCase(k)) continue;
                    key = k;
                    break;
                }
                if (null != (chk = list.get(0).get(key)) && chk instanceof Map) {
                    result = new ArrayList<Map<String, Object>>();
                    for (Map<String, Object> item : list) {
                        Map value = (Map)item.get(key);
                        if (mapHashIdKey) {
                            value.put("id", item.get(id_key));
                        }
                        result.add(value);
                    }
                }
            }
        }
        return result;
    }

    protected void fillQueryContent(DataRuntime runtime, XMLRun run) {
    }

    protected void fillQueryContent(DataRuntime runtime, TextRun run) {
        StringBuilder builder = run.getBuilder();
        RunPrepare prepare = run.getPrepare();
        List variables = run.getVariables();
        String result = prepare.getText();
        if (null != variables) {
            List varValues;
            String value;
            for (Variable var : variables) {
                if (null == var || var.getType() != 3) continue;
                List varValue = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((Object)varValue)) {
                    value = varValue.toString();
                }
                if (null != value) {
                    result = result.replace("::" + var.getKey(), value);
                    continue;
                }
                result = result.replace("::" + var.getKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 2) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)varValues)) {
                    value = (String)varValues.get(0);
                }
                if (null != value) {
                    result = result.replace(":" + var.getKey(), value);
                    continue;
                }
                result = result.replace(":" + var.getKey(), "");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 1 || !BasicUtil.isNotEmpty((boolean)true, (Object)(varValues = var.getValues()))) continue;
                if (var.getCompare() == Compare.IN) {
                    String replaceSrc = ":" + var.getKey();
                    String replaceDst = "";
                    for (Object tmp : varValues) {
                        run.addValues(var.getKey(), tmp);
                        replaceDst = replaceDst + " ?";
                    }
                    replaceDst = replaceDst.trim().replace(" ", ", ");
                    result = result.replace(replaceSrc, replaceDst);
                    continue;
                }
                result = result.replace(":" + var.getKey(), "?");
                run.addValues(var.getKey(), varValues.get(0));
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 0) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)varValues)) {
                    value = (String)varValues.get(0);
                }
                run.addValues(var.getKey(), (Object)value);
            }
        }
        builder.append(result);
        run.appendCondition(true);
        run.appendGroup();
        run.checkValid();
    }

    protected void fillQueryContent(DataRuntime runtime, TableRun run) {
        StringBuilder builder = run.getBuilder();
        RunPrepare prepare = run.getPrepare();
        String alias = prepare.getAlias();
        if (BasicUtil.isEmpty((Object)alias)) {
            alias = "e";
            prepare.setAlias(alias);
        }
        builder.append("MATCH (").append(alias);
        Table table = run.getTable();
        if (BasicUtil.isNotEmpty((Object)table)) {
            builder.append(":");
            this.name(runtime, builder, (Metadata)run.getTable());
        }
        builder.append(") ");
        run.appendCondition((DriverAdapter)this, true, true);
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
    }

    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        String sql = run.getBaseQuery() + " RETURN COUNT(" + run.getPrepare().getAlias() + ") AS CNT";
        return sql;
    }

    public String mergeFinalExists(DataRuntime runtime, Run run) {
        String sql = run.getBaseQuery() + " RETURN COUNT(" + run.getPrepare().getAlias() + ") > 0  AS IS_EXISTS";
        return sql;
    }

    public Run buildUpdateRunFromEntity(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(2);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap<Object, Object> keys = new LinkedHashMap();
        LinkedHashMap<String, Column> primaryKeys = new LinkedHashMap<String, Column>();
        if (null != columns && columns.size() > 0) {
            keys = columns;
        } else {
            keys.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.UPDATE));
        }
        if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            primaryKeys.putAll(EntityAdapterProxy.primaryKeys(obj.getClass()));
        } else {
            primaryKeys = new LinkedHashMap();
            primaryKeys.put(Neo4jRow.DEFAULT_PRIMARY_KEY, new Column(Neo4jRow.DEFAULT_PRIMARY_KEY));
        }
        for (String pk : primaryKeys.keySet()) {
            if (columns.containsKey(pk)) continue;
            keys.remove(pk);
        }
        if (!columns.containsKey(Neo4jRow.DEFAULT_PRIMARY_KEY.toUpperCase())) {
            keys.remove(Neo4jRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!keys.isEmpty()) {
            builder.append("UPDATE ").append(dest.getName());
            builder.append(" SET").append("\n\t");
            boolean start = true;
            for (Column column : keys.values()) {
                if (!start) {
                    builder.append(",");
                }
                start = false;
                String key = column.getName();
                Object value = null;
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
                    value = BeanUtil.getFieldValue((Object)obj, (Field)field);
                } else {
                    value = BeanUtil.getFieldValue((Object)obj, (String)key);
                }
                if (BasicUtil.checkEl((String)(value + ""))) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    this.delimiter(builder, key).append(" = ").append(value).append("\n\t");
                    continue;
                }
                this.delimiter(builder, key).append(" = ?").append("\n\t");
                if ("NULL".equals(value)) {
                    value = null;
                }
                updateColumns.add(key);
                run.addValues(Compare.EQUAL, column, value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
            }
            builder.append("\n");
            run.setConfigStore(configs);
            run.init();
            run.appendCondition((DriverAdapter)this, true, true);
        }
        run.setUpdateColumns(updateColumns);
        return run;
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        StringBuilder builder = new StringBuilder();
        LinkedHashMap cols = this.confirmUpdateColumns(runtime, dest, row, configs, Column.names(columns));
        List primaryKeys = row.getPrimaryKeys();
        if (primaryKeys.isEmpty()) {
            throw new CommandUpdateException("[\u66f4\u65b0\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a, update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        for (String pk : primaryKeys) {
            if (columns.containsKey(pk.toUpperCase())) continue;
            cols.remove(pk.toUpperCase());
        }
        if (!columns.containsKey(Neo4jRow.DEFAULT_PRIMARY_KEY.toUpperCase())) {
            cols.remove(Neo4jRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ").append(dest.getName());
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = row.get(key);
                if (!first) {
                    builder.append(",");
                }
                first = false;
                if (BasicUtil.checkEl((String)(value + ""))) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    this.delimiter(builder, key).append(" = ").append(value).append("\n\t");
                    continue;
                }
                this.delimiter(builder, key).append(" = ?").append("\n\t");
                if ("NULL".equals(value)) {
                    value = null;
                }
                updateColumns.add(key);
                run.addValues(Compare.EQUAL, column, value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
            }
            builder.append("\n");
            run.setConfigStore(configs);
            run.init();
            run.appendCondition((DriverAdapter)this, true, true);
        }
        run.setUpdateColumns(updateColumns);
        run.setBuilder(builder);
        return run;
    }

    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return null;
    }

    public void fillDeleteRunContent(DataRuntime runtime, TableRun run) {
        List joins;
        RunPrepare prepare = run.getPrepare();
        StringBuilder builder = run.getBuilder();
        builder.append("DELETE FROM ");
        this.name(runtime, builder, (Metadata)run.getTable());
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)prepare.getAlias())) {
            builder.append("  ").append(prepare.getAlias());
        }
        if (null != (joins = prepare.getJoins())) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                Table table = join.getTable();
                this.delimiter(builder, table.getName());
                if (BasicUtil.isNotEmpty((Object)table.getAlias())) {
                    builder.append("  ").append(table.getAlias());
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        run.appendCondition((DriverAdapter)this, true, true);
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, ConfigStore configs, String key, Object values) {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (null == table || null == key || null == values) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        TableRun run = new TableRun(runtime, table);
        builder.append("DELETE FROM ").append(table).append(" WHERE ");
        if (values instanceof Collection) {
            Collection cons = (Collection)values;
            this.delimiter(builder, key);
            if (cons.size() > 1) {
                builder.append(" IN(");
                int idx = 0;
                for (Object obj : cons) {
                    if (idx > 0) {
                        builder.append(",");
                    }
                    builder.append("?");
                    ++idx;
                }
                builder.append(")");
            } else {
                if (cons.size() != 1) throw new CommandUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a, delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
                for (Object obj : cons) {
                    builder.append("=?");
                }
            }
        } else {
            this.delimiter(builder, key);
            builder.append("=?");
        }
        run.addValues(Compare.IN, new Column(key), values, ConfigTable.IS_AUTO_SPLIT_ARRAY);
        run.setBuilder(builder);
        runs.add((Run)run);
        return runs;
    }

    public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, Table dest, ConfigStore configs, Object obj, String ... columns) {
        ArrayList<Run> runs = new ArrayList<Run>();
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(2);
        StringBuilder builder = new StringBuilder();
        builder.append("MATCH (d");
        if (null != dest) {
            builder.append(":").append(dest.getName());
        }
        builder.append(")");
        builder.append(" WHERE ");
        List<String> keys = new ArrayList();
        if (null != columns && columns.length > 0) {
            for (String col : columns) {
                keys.add(col);
            }
        } else if (obj instanceof DataRow) {
            keys = ((DataRow)obj).getPrimaryKeys();
        } else {
            keys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        }
        int size = keys.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append("\nAND ");
                }
                String key = (String)keys.get(i);
                this.delimiter(builder, "d." + key).append(" = ? ");
                Object value = null;
                value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
                run.addValues(Compare.EQUAL, new Column(key), value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
            }
        } else {
            throw new CommandUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a, delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
        }
        builder.append(" DELETE d");
        run.setBuilder(builder);
        runs.add((Run)run);
        return runs;
    }
}

