/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.oracle;

import java.util.List;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.oracle.OracleAdapter;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.RegularUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.oracle.11")
public class Oracle11Adapter
extends OracleAdapter
implements JDBCAdapter,
InitializingBean {
    @Override
    public String version() {
        return "11";
    }

    @Override
    public boolean match(DataRuntime runtime) {
        String version;
        List keywords = this.type().keywords();
        String feature = runtime.getFeature();
        boolean chk = this.match(feature, keywords);
        if (chk && null != (version = runtime.getVersion())) {
            double v;
            if (null != (version = RegularUtil.cut((String)version, (String[])new String[]{"release", "-"}))) {
                version = version.split("\\.")[0];
            }
            if ((v = BasicUtil.parseDouble((Object)version, (Double)0.0).doubleValue()) < 12.0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        long last = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            builder.append("SELECT " + cols + " FROM( \n");
            builder.append("SELECT TAB_I.* ,ROWNUM AS PAGE_ROW_NUMBER_ \n");
            builder.append("FROM( \n");
            builder.append(sql);
            builder.append("\n").append(order);
            builder.append(")  TAB_I \n");
            builder.append(")  TAB_O WHERE PAGE_ROW_NUMBER_ >= " + (first + 1L) + " AND PAGE_ROW_NUMBER_ <= " + (last + 1L));
        }
        return builder.toString();
    }
}

