/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.oracle;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import org.anyline.adapter.DataWriter;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.proxy.ConvertProxy;
import org.anyline.util.DateUtil;

public enum OracleWriter {
    DateWriter(new Object[]{java.sql.Date.class, Timestamp.class, Date.class, LocalDate.class, LocalDateTime.class, TIMESTAMP.class, TIMESTAMPTZ.class, TIMESTAMPLTZ.class, TIMEZONETAB.class, DATE.class}, new DataWriter(){

        public Object write(Object value, boolean placeholder, TypeMetadata type) {
            if (!placeholder && null != value) {
                Date date = (Date)ConvertProxy.convert((Object)value, Date.class, (boolean)false);
                value = " to_date ( '" + DateUtil.format((Date)date) + "', 'YYYY-MM-DD HH24:MI:SS')";
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataWriter writer;

    public Object[] supports() {
        return this.supports;
    }

    public DataWriter writer() {
        return this.writer;
    }

    private OracleWriter(Object[] supports, DataWriter writer) {
        this.supports = supports;
        this.writer = writer;
    }
}

