/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.tdengine;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.init.SQLAdapter;
import org.anyline.data.jdbc.tdengine.TDengineColumnTypeAlias;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.ColumnType;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.tdengine")
public class TDengineAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.tdengine:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.TDengine;
    }

    public TDengineAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
        for (TDengineColumnTypeAlias alias : TDengineColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public Object buildConditionLike(StringBuilder builder, Compare compare, Object value) {
        if (null != value) {
            if (value instanceof Collection) {
                value = ((Collection)value).iterator().next();
            }
            if (compare == Compare.LIKE) {
                builder.append(" LIKE '%" + value + "%'");
            } else if (compare == Compare.LIKE_PREFIX || compare == Compare.START_WITH) {
                builder.append(" LIKE'" + value + "%'");
            } else if (compare == Compare.LIKE_SUFFIX || compare == Compare.END_WITH) {
                builder.append(" LIKE '%" + value + "'");
            }
        }
        return null;
    }

    public String batchInsertSeparator() {
        return " ";
    }

    public boolean supportInsertPlaceholder() {
        return false;
    }

    public int insert(JdbcTemplate template, String random, Object data, final String sql, final List<Object> values, String[] pks) throws Exception {
        int cnt = 0;
        if (null != values && values.size() != 0) {
            cnt = template.update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement ps = null;
                    ps = con.prepareStatement(sql);
                    int idx = 0;
                    if (null != values) {
                        for (Object obj : values) {
                            ps.setObject(++idx, obj);
                        }
                    }
                    return ps;
                }
            });
            return cnt;
        }
        cnt = template.update(sql);
        return cnt;
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        return this.concatFun(args);
    }

    public List<Run> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SHOW TABLES");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" LIKE '" + pattern + "'");
        }
        SimpleRun r = new SimpleRun();
        runs.add((Run)r);
        builder = r.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TABLES WHERE TYPE = 'NORMAL_TABLE' ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            builder.append(" AND DB_NAME = '" + catalog + "'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '" + pattern + "'");
        }
        return runs;
    }

    public List<Run> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableCommentRunSQL(catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        block5: {
            block4: {
                if (null == tables) {
                    tables = new LinkedHashMap();
                }
                if (index != 0) break block4;
                for (DataRow row : set) {
                    Table table;
                    String name = row.getString("stable_name");
                    if (BasicUtil.isEmpty((Object)name) || null != (table = (Table)tables.get(name.toUpperCase())) || !create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                break block5;
            }
            if (index != 1) break block5;
            for (DataRow row : set) {
                String name = row.getString("stable_name");
                if (BasicUtil.isEmpty((Object)name)) continue;
                Table table = (Table)tables.get(name.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                table.setCatalog(row.getString("db_name"));
                table.setType(row.getString("type"));
                table.setComment(row.getString("table_comment"));
            }
        }
        return tables;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String sql = "SHOW STABLES";
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            sql = sql + " LIKE '" + pattern + "'";
        }
        runs.add((Run)new SimpleRun(sql));
        sql = "SELECT * FROM INFORMATION_SCHEMA.INS_STABLES WHERE 1=1 ";
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            sql = sql + " AND DB_NAME = '" + catalog + "'";
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            sql = sql + " AND STABLE_NAME LIKE '" + pattern + "'";
        }
        runs.add((Run)new SimpleRun(sql));
        return runs;
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        block5: {
            block4: {
                if (null == tables) {
                    tables = new LinkedHashMap();
                }
                if (index != 0) break block4;
                for (DataRow row : set) {
                    MasterTable table;
                    String name = row.getString("stable_name");
                    if (BasicUtil.isEmpty((Object)name) || null != (table = (MasterTable)tables.get(name.toUpperCase())) || !create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                break block5;
            }
            if (index != 1) break block5;
            for (DataRow row : set) {
                String name = row.getString("stable_name");
                if (BasicUtil.isEmpty((Object)name)) continue;
                MasterTable table = (MasterTable)tables.get(name.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                table.setCatalog(row.getString("db_name"));
                table.setComment(row.getString("table_comment"));
            }
        }
        return tables;
    }

    public List<Run> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags, String name) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String stable = null;
        if (null != master) {
            stable = master.getName();
        }
        if (null != tags && tags.size() > 0) {
            for (String key : tags.keySet()) {
                SimpleRun run = new SimpleRun();
                runs.add((Run)run);
                StringBuilder builder = run.getBuilder();
                Object value = tags.get(key);
                builder.append("SELECT table_name FROM INFORMATION_SCHEMA.INS_TAGS WHERE STABLE_NAME = '").append(stable).append("'").append(" AND TAG_NAME ='").append(key.toLowerCase()).append("'").append(" AND TAG_VALUE ");
                if (null == value) {
                    builder.append("IS NULL");
                    continue;
                }
                if (BasicUtil.isNumber((Object)value)) {
                    builder.append("= ").append(value);
                    continue;
                }
                builder.append("= '").append(value).append("'");
            }
        }
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TABLES WHERE STABLE_NAME = '").append(stable).append("'");
        if (BasicUtil.isNotEmpty((Object)name)) {
            builder.append(" AND TABLE_NAME = '").append(name).append("'");
        }
        return runs;
    }

    public List<Run> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags) throws Exception {
        return this.buildQueryPartitionTableRunSQL(master, tags, null);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (index == 0) {
            tables = new LinkedHashMap();
            for (DataRow row : set) {
                String name = row.getString("table_name");
                PartitionTable table = new PartitionTable(name);
                tables.put(name, table);
            }
        } else if (index < total - 1) {
            tables.keySet().retainAll(set.getStrings("table_name"));
        }
        if (index == total - 1) {
            LinkedHashMap<String, PartitionTable> result = new LinkedHashMap<String, PartitionTable>();
            for (DataRow row : set) {
                String name = row.getString("table_name");
                if (!tables.containsKey(name)) continue;
                PartitionTable table = new PartitionTable(name);
                result.put(name.toUpperCase(), table);
                table.setCatalog(row.getString("db_name"));
                table.setComment(row.getString("table_comment"));
                table.setMaster(master);
                result.put(name, table);
            }
            tables.clear();
            for (String key : result.keySet()) {
                tables.put(key.toUpperCase(), result.get(key));
            }
        }
        return tables;
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
        } else {
            builder.append("DESCRIBE ").append(table.getName());
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("field");
            String note = row.getString("note");
            if (BasicUtil.isEmpty((Object)name) || "TAG".equalsIgnoreCase(note)) continue;
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) {
                if (!create) continue;
                column = new Column();
                columns.put(name.toUpperCase(), column);
            }
            column.setName(name);
            column.setCatalog(table.getCatalog());
            column.setSchema(table.getSchema());
            column.setTypeName(row.getString("type"));
            column.setPrecision(row.getInt("length", Integer.valueOf(0)));
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
        return columns;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(false, columns, dbmd, table, pattern);
    }

    public List<Run> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        StringBuilder builder = new StringBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
            runs.add((Run)new SimpleRun(builder));
        } else {
            if (table instanceof MasterTable) {
                builder.append("SELECT DISTINCT STABLE_NAME,DB_NAME,TAG_NAME,TAG_TYPE FROM INFORMATION_SCHEMA.INS_TAGS WHERE db_name = '");
                builder.append(table.getCatalog()).append("' AND STABLE_NAME='").append(table.getName()).append("'");
            } else {
                builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TAGS WHERE db_name = '");
                builder.append(table.getCatalog()).append("' AND TABLE_NAME='").append(table.getName()).append("'");
            }
            runs.add((Run)new SimpleRun(builder));
            builder = new StringBuilder();
            builder.append("DESCRIBE ").append(table.getName());
            runs.add((Run)new SimpleRun(builder));
        }
        return runs;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        block6: {
            block5: {
                if (null == tags) {
                    tags = new LinkedHashMap();
                }
                if (index != 0) break block5;
                for (DataRow row : set) {
                    String name = row.getString("TAG_NAME");
                    if (BasicUtil.isEmpty((Object)name)) continue;
                    Tag item = (Tag)tags.get(name.toUpperCase());
                    if (null == item) {
                        if (!create) continue;
                        item = new Tag();
                    }
                    item.setName(name);
                    item.setTypeName(row.getString("TAG_TYPE"));
                    item.setValue(row.get("TAG_VALUE"));
                    tags.put(name.toUpperCase(), item);
                }
                break block6;
            }
            if (index != 1) break block6;
            for (DataRow row : set) {
                String name;
                String note = row.getString("note");
                if (!"TAG".equalsIgnoreCase(note) || BasicUtil.isEmpty((Object)(name = row.getString("field")))) continue;
                Tag item = (Tag)tags.get(name.toUpperCase());
                if (null == item) {
                    if (!create) continue;
                    item = new Tag();
                }
                item.setName(name);
                item.setTypeName(row.getString("type"));
                item.setPrecision(row.getInt("length", Integer.valueOf(0)));
                item.setValue(row.get("TAG_VALUE"));
                tags.put(name.toUpperCase(), item);
            }
        }
        return tags;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return tags;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, LinkedHashMap<String, T> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    public List<Run> buildQueryIndexRunSQL(Table table, String name) {
        return super.buildQueryIndexRunSQL(table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, LinkedHashMap<String, T> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRunSQL(Table table, List<Trigger.EVENT> events) {
        return super.buildQueryTriggerRunSQL(table, events);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        return super.triggers(index, create, table, triggers, set);
    }

    public List<Run> buildCreateRunSQL(Table table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<Run> buildAddCommentRunSQL(Table table) throws Exception {
        return super.buildAddCommentRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRunSQL(table, columns);
    }

    public List<Run> buildRenameRunSQL(Table table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public List<Run> buildChangeCommentRunSQL(Table table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<Run> buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return super.checkTableExists(builder, exists);
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public List<Run> buildCreateRunSQL(View view) throws Exception {
        return super.buildCreateRunSQL(view);
    }

    public List<Run> buildAddCommentRunSQL(View view) throws Exception {
        return super.buildAddCommentRunSQL(view);
    }

    public List<Run> buildAlterRunSQL(View view) throws Exception {
        return super.buildAlterRunSQL(view);
    }

    public List<Run> buildRenameRunSQL(View view) throws Exception {
        return super.buildRenameRunSQL(view);
    }

    public List<Run> buildChangeCommentRunSQL(View view) throws Exception {
        return super.buildChangeCommentRunSQL(view);
    }

    public List<Run> buildDropRunSQL(View view) throws Exception {
        return super.buildDropRunSQL(view);
    }

    public StringBuilder checkViewExists(StringBuilder builder, boolean exists) {
        return super.checkViewExists(builder, exists);
    }

    public StringBuilder comment(StringBuilder builder, View view) {
        return super.comment(builder, view);
    }

    public List<Run> buildCreateRunSQL(MasterTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        MasterTable tab = table;
        List<Run> list = this.buildCreateRunSQL((Table)tab);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Run sql = list.get(i);
            if (i == 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(sql.getFinalUpdate());
                builder.append(" TAGS (");
                LinkedHashMap tags = table.getTags();
                int idx = 0;
                for (Tag tag : tags.values()) {
                    if (idx > 0) {
                        builder.append(",");
                    }
                    SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                    this.type(builder, (Column)tag);
                    ++idx;
                }
                builder.append(")");
                runs.add((Run)new SimpleRun(builder));
                continue;
            }
            runs.add(sql);
        }
        return runs;
    }

    public List<Run> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildDropRunSQL(MasterTable table) throws Exception {
        MasterTable tab = table;
        return super.buildDropRunSQL((Table)tab);
    }

    public List<Run> buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public List<Run> buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<Run> buildCreateRunSQL(PartitionTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String stable = table.getMasterName();
        if (BasicUtil.isEmpty((Object)stable)) {
            throw new SQLException("\u672a\u6307\u5b9a\u4e3b\u8868");
        }
        PartitionTable tab = table;
        builder.append(((Run)super.buildCreateRunSQL((Table)tab).get(0)).getFinalUpdate());
        builder.append(" USING ");
        SQLUtil.delimiter((StringBuilder)builder, (String)stable, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append("(");
        Collection tags = table.getTags().values();
        int idx = 0;
        for (Tag tag : tags) {
            if (idx > 0) {
                builder.append(",");
            }
            SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            ++idx;
        }
        builder.append(") TAGS (");
        idx = 0;
        for (Tag tag : tags) {
            if (idx > 0) {
                builder.append(",");
            }
            builder.append(this.write(null, tag.getValue(), false));
            ++idx;
        }
        builder.append(")");
        return runs;
    }

    public List<Run> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildDropRunSQL(PartitionTable table) throws Exception {
        PartitionTable tab = table;
        return super.buildDropRunSQL((Table)tab);
    }

    public List<Run> buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public List<Run> buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return "ALTER";
    }

    public List<Run> buildAddRunSQL(Column column, boolean slice) throws Exception {
        return super.buildAddRunSQL(column, slice);
    }

    public List<Run> buildAddRunSQL(Column column) throws Exception {
        return this.buildAddRunSQL(column, false);
    }

    public List<Run> buildAlterRunSQL(Column column, boolean slice) throws Exception {
        return super.buildAlterRunSQL(column, slice);
    }

    public List<Run> buildAlterRunSQL(Column column) throws Exception {
        return this.buildAlterRunSQL(column, false);
    }

    public List<Run> buildDropRunSQL(Column column, boolean slice) throws Exception {
        return super.buildDropRunSQL(column, slice);
    }

    public List<Run> buildRenameRunSQL(Column column) throws Exception {
        return super.buildRenameRunSQL(column);
    }

    public List<Run> buildChangeTypeRunSQL(Column column) throws Exception {
        return super.buildChangeTypeRunSQL(column);
    }

    public List<Run> buildChangeDefaultRunSQL(Column column) throws Exception {
        return super.buildChangeDefaultRunSQL(column);
    }

    public List<Run> buildChangeNullableRunSQL(Column column) throws Exception {
        return super.buildChangeNullableRunSQL(column);
    }

    public List<Run> buildAddCommentRunSQL(Column column) throws Exception {
        return this.buildChangeCommentRunSQL(column);
    }

    public List<Run> buildChangeCommentRunSQL(Column column) throws Exception {
        return super.buildChangeCommentRunSQL(column);
    }

    public List<Run> buildDropAutoIncrement(Column column) throws Exception {
        return super.buildDropAutoIncrement(column);
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        Integer precision;
        String typeName;
        if (null == builder) {
            builder = new StringBuilder();
        }
        if (BasicUtil.isEmpty((Object)(typeName = column.getTypeName()))) {
            return builder;
        }
        builder.append(typeName);
        if (typeName.equalsIgnoreCase("NCHAR") && null != (precision = column.getPrecision()) && precision > 0) {
            builder.append("(").append(precision).append(")");
        }
        return builder;
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        if (column instanceof Tag) {
            String comment = column.getComment();
            if (BasicUtil.isNotEmpty((Object)comment)) {
                builder.append(" COMMENT '").append(comment).append("'");
            }
            return builder;
        }
        return null;
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public List<Run> buildAddRunSQL(Tag tag) throws Exception {
        return super.buildAddRunSQL(tag);
    }

    public List<Run> buildAlterRunSQL(Tag tag) throws Exception {
        return super.buildAlterRunSQL(tag);
    }

    public List<Run> buildDropRunSQL(Tag tag) throws Exception {
        return super.buildDropRunSQL(tag);
    }

    public List<Run> buildRenameRunSQL(Tag tag) throws Exception {
        return super.buildRenameRunSQL(tag);
    }

    public List<Run> buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return super.buildChangeDefaultRunSQL(tag);
    }

    public List<Run> buildChangeNullableRunSQL(Tag tag) throws Exception {
        return super.buildChangeNullableRunSQL(tag);
    }

    public List<Run> buildChangeCommentRunSQL(Tag tag) throws Exception {
        return super.buildChangeCommentRunSQL(tag);
    }

    public List<Run> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return super.buildChangeTypeRunSQL(tag);
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public List<Run> buildAddRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAddRunSQL(primary);
    }

    public List<Run> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAlterRunSQL(primary);
    }

    public List<Run> buildDropRunSQL(PrimaryKey primary) throws Exception {
        return super.buildDropRunSQL(primary);
    }

    public List<Run> buildRenameRunSQL(PrimaryKey primary) throws Exception {
        return super.buildRenameRunSQL(primary);
    }

    public List<Run> buildAddRunSQL(ForeignKey foreign) throws Exception {
        return super.buildAddRunSQL(foreign);
    }

    public List<Run> buildAlterRunSQL(ForeignKey foreign) throws Exception {
        return super.buildAlterRunSQL(foreign);
    }

    public List<Run> buildDropRunSQL(ForeignKey foreign) throws Exception {
        return super.buildDropRunSQL(foreign);
    }

    public List<Run> buildRenameRunSQL(ForeignKey foreign) throws Exception {
        return super.buildRenameRunSQL(foreign);
    }

    public List<Run> buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<Run> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public List<Run> buildDropRunSQL(Index index) throws Exception {
        return super.buildDropRunSQL(index);
    }

    public List<Run> buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public void comment(StringBuilder builder, Index index) {
        super.comment(builder, index);
    }

    public List<Run> buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<Run> buildAlterRunSQL(Constraint constraint) throws Exception {
        return this.buildAlterRunSQL(constraint);
    }

    public List<Run> buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public List<Run> buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public List<Run> buildCreateRunSQL(Trigger trigger) throws Exception {
        return super.buildCreateRunSQL(trigger);
    }

    public void each(StringBuilder builder, Trigger trigger) {
        super.each(builder, trigger);
    }

    public List<Run> buildAlterRunSQL(Trigger trigger) throws Exception {
        return super.buildAlterRunSQL(trigger);
    }

    public List<Run> buildDropRunSQL(Trigger trigger) throws Exception {
        return super.buildDropRunSQL(trigger);
    }

    public List<Run> buildRenameRunSQL(Trigger trigger) throws Exception {
        return super.buildRenameRunSQL(trigger);
    }

    public List<Run> buildCreateRunSQL(Procedure procedure) throws Exception {
        return super.buildCreateRunSQL(procedure);
    }

    public List<Run> buildAlterRunSQL(Procedure procedure) throws Exception {
        return super.buildAlterRunSQL(procedure);
    }

    public List<Run> buildDropRunSQL(Procedure procedure) throws Exception {
        return super.buildDropRunSQL(procedure);
    }

    public List<Run> buildRenameRunSQL(Procedure procedure) throws Exception {
        return super.buildRenameRunSQL(procedure);
    }

    public List<Run> buildCreateRunSQL(Function function) throws Exception {
        return super.buildCreateRunSQL(function);
    }

    public List<Run> buildAlterRunSQL(Function function) throws Exception {
        return super.buildAlterRunSQL(function);
    }

    public List<Run> buildDropRunSQL(Function function) throws Exception {
        return super.buildDropRunSQL(function);
    }

    public List<Run> buildRenameRunSQL(Function function) throws Exception {
        return super.buildRenameRunSQL(function);
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String value(Column column, JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "NOW";
        }
        return null;
    }
}

